/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.faces.validator._MessageUtils;

public class LengthValidator
implements Validator,
PartialStateHolder {
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MINIMUM";
    public static final String VALIDATOR_ID = "javax.faces.Length";
    private Integer _minimum = null;
    private Integer _maximum = null;
    private boolean _transient = false;
    private boolean _initialStateMarked = false;

    public LengthValidator() {
    }

    public LengthValidator(int maximum) {
        this._maximum = maximum;
    }

    public LengthValidator(int maximum, int minimum) {
        this._maximum = maximum;
        this._minimum = minimum;
    }

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        int length;
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return;
        }
        int n = length = value instanceof String ? ((String)value).length() : value.toString().length();
        if (this._minimum != null && length < this._minimum) {
            Object[] args = new Object[]{this._minimum, _MessageUtils.getLabel(facesContext, uiComponent)};
            throw new ValidatorException(_MessageUtils.getErrorMessage(facesContext, MINIMUM_MESSAGE_ID, args));
        }
        if (this._maximum != null && length > this._maximum) {
            Object[] args = new Object[]{this._maximum, _MessageUtils.getLabel(facesContext, uiComponent)};
            throw new ValidatorException(_MessageUtils.getErrorMessage(facesContext, MAXIMUM_MESSAGE_ID, args));
        }
    }

    public int getMaximum() {
        return this._maximum != null ? this._maximum : 0;
    }

    public void setMaximum(int maximum) {
        this._maximum = maximum;
        this.clearInitialState();
    }

    public int getMinimum() {
        return this._minimum != null ? this._minimum : 0;
    }

    public void setMinimum(int minimum) {
        this._minimum = minimum;
        this.clearInitialState();
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean transientValue) {
        this._transient = transientValue;
    }

    public Object saveState(FacesContext context) {
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this._maximum, this._minimum};
            return values;
        }
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
        if (state != null) {
            Object[] values = (Object[])state;
            this._maximum = (Integer)values[0];
            this._minimum = (Integer)values[1];
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LengthValidator)) {
            return false;
        }
        LengthValidator lengthValidator = (LengthValidator)o;
        if (this._maximum != null ? !this._maximum.equals(lengthValidator._maximum) : lengthValidator._maximum != null) {
            return false;
        }
        return !(this._minimum != null ? !this._minimum.equals(lengthValidator._minimum) : lengthValidator._minimum != null);
    }

    public int hashCode() {
        int result = this._minimum != null ? this._minimum.hashCode() : 0;
        result = 31 * result + (this._maximum != null ? this._maximum.hashCode() : 0);
        return result;
    }

    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    public void markInitialState() {
        this._initialStateMarked = true;
    }

    private Boolean isDisabled() {
        return null;
    }

    private String getFor() {
        return null;
    }
}

