/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlSelectManyListbox;
import javax.faces.component.html.HtmlSelectOneListbox;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.HtmlSelectableRendererBase;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;

public class HtmlListboxRendererBase
extends HtmlSelectableRendererBase {
    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Integer size;
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        Map<String, List<ClientBehavior>> behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)((Object)uiComponent)).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
        }
        if ((size = (Integer)uiComponent.getAttributes().get("size")) == null) {
            size = Integer.MIN_VALUE;
        }
        if (uiComponent instanceof UISelectMany) {
            this.renderListbox(facesContext, (UISelectMany)uiComponent, this.isDisabled(facesContext, uiComponent), (int)size, this.getConverter(facesContext, uiComponent));
        } else if (uiComponent instanceof HtmlSelectOneListbox) {
            this.renderListbox(facesContext, (UISelectOne)uiComponent, this.isDisabled(facesContext, uiComponent), (int)size, this.getConverter(facesContext, uiComponent));
        } else {
            throw new IllegalArgumentException("Unsupported component class " + uiComponent.getClass().getName());
        }
    }

    protected void renderListbox(FacesContext facesContext, UISelectOne selectOne, boolean disabled, int size, Converter converter) throws IOException {
        this.internalRenderSelect(facesContext, selectOne, disabled, size, false, converter);
    }

    protected void renderListbox(FacesContext facesContext, UISelectMany selectMany, boolean disabled, int size, Converter converter) throws IOException {
        this.internalRenderSelect(facesContext, selectMany, disabled, size, true, converter);
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent instanceof HtmlSelectManyListbox) {
            return ((HtmlSelectManyListbox)uiComponent).isDisabled();
        }
        if (uiComponent instanceof HtmlSelectOneListbox) {
            return ((HtmlSelectOneListbox)uiComponent).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(uiComponent, "disabled", false);
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof UISelectMany) {
            HtmlRendererUtils.decodeUISelectMany(facesContext, uiComponent);
        } else if (uiComponent instanceof UISelectOne) {
            HtmlRendererUtils.decodeUISelectOne(facesContext, uiComponent);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + uiComponent.getClass().getName());
        }
        if (uiComponent instanceof ClientBehaviorHolder && !HtmlRendererUtils.isDisabled(uiComponent)) {
            HtmlRendererUtils.decodeClientBehaviors(facesContext, uiComponent);
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof UISelectMany) {
            return RendererUtils.getConvertedUISelectManyValue(facesContext, (UISelectMany)uiComponent, submittedValue);
        }
        if (uiComponent instanceof UISelectOne) {
            return RendererUtils.getConvertedUISelectOneValue(facesContext, (UISelectOne)uiComponent, submittedValue);
        }
        throw new IllegalArgumentException("Unsupported component class " + uiComponent.getClass().getName());
    }

    protected Converter getConverter(FacesContext facesContext, UIComponent component) {
        if (component instanceof UISelectMany) {
            return HtmlRendererUtils.findUISelectManyConverterFailsafe(facesContext, (UISelectMany)component);
        }
        if (component instanceof UISelectOne) {
            return HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, component);
        }
        return null;
    }
}

