/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.resource;

import java.io.InputStream;
import java.net.URL;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;
import org.apache.myfaces.shared.resource.AliasResourceMetaImpl;
import org.apache.myfaces.shared.resource.ResourceLoader;
import org.apache.myfaces.shared.resource.ResourceMeta;
import org.apache.myfaces.shared.resource.ResourceMetaImpl;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.shared.util.WebConfigParamUtils;

public class InternalClassLoaderResourceLoader
extends ResourceLoader {
    public static final String USE_MULTIPLE_JS_FILES_FOR_JSF_UNCOMPRESSED_JS = "org.apache.myfaces.USE_MULTIPLE_JS_FILES_FOR_JSF_UNCOMPRESSED_JS";
    public static final String MYFACES_JSF_MODE = "org.apache.myfaces.JSF_JS_MODE";
    private final boolean _useMultipleJsFilesForJsfUncompressedJs = WebConfigParamUtils.getBooleanInitParameter(FacesContext.getCurrentInstance().getExternalContext(), "org.apache.myfaces.USE_MULTIPLE_JS_FILES_FOR_JSF_UNCOMPRESSED_JS", false);
    private final String _jsfMode = WebConfigParamUtils.getStringInitParameter(FacesContext.getCurrentInstance().getExternalContext(), "org.apache.myfaces.JSF_JS_MODE", "normal");
    private final boolean _developmentStage = FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Development);

    public InternalClassLoaderResourceLoader(String prefix) {
        super(prefix);
    }

    @Override
    public String getLibraryVersion(String path) {
        return null;
    }

    @Override
    public InputStream getResourceInputStream(ResourceMeta resourceMeta) {
        if (this.getPrefix() != null && !"".equals(this.getPrefix())) {
            String name = this.getPrefix() + '/' + resourceMeta.getResourceIdentifier();
            InputStream is = this.getClassLoader().getResourceAsStream(name);
            if (is == null) {
                is = this.getClass().getClassLoader().getResourceAsStream(name);
            }
            return is;
        }
        InputStream is = this.getClassLoader().getResourceAsStream(resourceMeta.getResourceIdentifier());
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(resourceMeta.getResourceIdentifier());
        }
        return is;
    }

    public URL getResourceURL(String resourceId) {
        if (this.getPrefix() != null && !"".equals(this.getPrefix())) {
            String name = this.getPrefix() + '/' + resourceId;
            URL url = this.getClassLoader().getResource(name);
            if (url == null) {
                url = this.getClass().getClassLoader().getResource(name);
            }
            return url;
        }
        URL url = this.getClassLoader().getResource(resourceId);
        if (url == null) {
            url = this.getClass().getClassLoader().getResource(resourceId);
        }
        return url;
    }

    @Override
    public URL getResourceURL(ResourceMeta resourceMeta) {
        return this.getResourceURL(resourceMeta.getResourceIdentifier());
    }

    @Override
    public String getResourceVersion(String path) {
        return null;
    }

    @Override
    public ResourceMeta createResourceMeta(String prefix, String libraryName, String libraryVersion, String resourceName, String resourceVersion) {
        boolean javaxFaces;
        boolean javaxFacesLib = libraryName != null && "javax.faces".equals(libraryName);
        boolean bl = javaxFaces = javaxFacesLib && "jsf.js".equals(resourceName);
        if (javaxFaces) {
            if (this._developmentStage) {
                if (this._useMultipleJsFilesForJsfUncompressedJs) {
                    return new AliasResourceMetaImpl(prefix, libraryName, libraryVersion, resourceName, resourceVersion, "jsf-uncompressed.js", true);
                }
                return new AliasResourceMetaImpl(prefix, libraryName, libraryVersion, resourceName, resourceVersion, "jsf-uncompressed-full.js", false);
            }
            if (this._jsfMode.equals("minimal")) {
                return new AliasResourceMetaImpl(prefix, libraryName, libraryVersion, resourceName, resourceVersion, "jsf-minimal.js", false);
            }
            if (this._jsfMode.equals("minimal-modern")) {
                return new AliasResourceMetaImpl(prefix, libraryName, libraryVersion, resourceName, resourceVersion, "jsf-minimal-modern.js", false);
            }
            return null;
        }
        if (javaxFacesLib && !this._developmentStage && !this._jsfMode.equals("normal") && ("jsf-i18n.js".equals(resourceName) || "jsf-experimental.js".equals(resourceName) || "jsf-legacy.js".equals(resourceName))) {
            return new ResourceMetaImpl(prefix, libraryName, libraryVersion, resourceName, resourceVersion);
        }
        if (this._developmentStage && libraryName != null && "org.apache.myfaces".equals(libraryName) && "oamSubmit.js".equals(resourceName)) {
            return new AliasResourceMetaImpl(prefix, libraryName, libraryVersion, resourceName, resourceVersion, "oamSubmit-uncompressed.js", true);
        }
        if (this._developmentStage && libraryName != null && libraryName.startsWith("org.apache.myfaces.core")) {
            return new ResourceMetaImpl(prefix, libraryName, libraryVersion, resourceName, resourceVersion);
        }
        return null;
    }

    protected ClassLoader getClassLoader() {
        return ClassUtils.getContextClassLoader();
    }

    @Override
    public boolean libraryExists(String libraryName) {
        if (this.getPrefix() != null && !"".equals(this.getPrefix())) {
            URL url = this.getClassLoader().getResource(this.getPrefix() + '/' + libraryName);
            if (url == null) {
                url = this.getClass().getClassLoader().getResource(this.getPrefix() + '/' + libraryName);
            }
            if (url != null) {
                return true;
            }
        } else {
            URL url = this.getClassLoader().getResource(libraryName);
            if (url == null) {
                url = this.getClass().getClassLoader().getResource(libraryName);
            }
            if (url != null) {
                return true;
            }
        }
        return false;
    }
}

