/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.ui;

import java.io.IOException;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.ELExpressionCacheMode;
import org.apache.myfaces.view.facelets.el.FaceletStateValueExpression;
import org.apache.myfaces.view.facelets.el.FaceletStateValueExpressionUEL;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;
import org.apache.myfaces.view.facelets.tag.jsf.FaceletState;

public class ParamHandler
extends TagHandler {
    private final TagAttribute name = this.getRequiredAttribute("name");
    private final TagAttribute value = this.getRequiredAttribute("value");

    public ParamHandler(TagConfig config) {
        super(config);
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        String nameStr = this.getName(ctx);
        ValueExpression valueVE = this.getValue(ctx);
        this.apply(ctx, parent, nameStr, valueVE);
    }

    public void apply(FaceletContext ctx, UIComponent parent, String nameStr, ValueExpression valueVE) throws IOException, FacesException, FaceletException, ELException {
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        actx.getTemplateContext().setParameter(nameStr, valueVE);
        if (actx.getTemplateContext().isAllowCacheELExpressions() && (ELExpressionCacheMode.strict.equals((Object)actx.getELExpressionCacheMode()) || ELExpressionCacheMode.allowCset.equals((Object)actx.getELExpressionCacheMode()))) {
            actx.getTemplateContext().setAllowCacheELExpressions(false);
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent, String nameStr, ValueExpression valueVE, String uniqueId) throws IOException, FacesException, FaceletException, ELException {
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        if (ELExpressionCacheMode.alwaysRecompile.equals((Object)actx.getELExpressionCacheMode())) {
            FaceletState faceletState = ComponentSupport.getFaceletState(ctx, parent, true);
            faceletState.putBinding(uniqueId, nameStr, valueVE);
            FaceletStateValueExpression ve = ExternalSpecifications.isUnifiedELAvailable() ? new FaceletStateValueExpressionUEL(uniqueId, nameStr) : new FaceletStateValueExpression(uniqueId, nameStr);
            actx.getTemplateContext().setParameter(nameStr, ve);
        } else {
            actx.getTemplateContext().setParameter(nameStr, valueVE);
        }
        if (actx.getTemplateContext().isAllowCacheELExpressions() && (ELExpressionCacheMode.strict.equals((Object)actx.getELExpressionCacheMode()) || ELExpressionCacheMode.allowCset.equals((Object)actx.getELExpressionCacheMode()))) {
            actx.getTemplateContext().setAllowCacheELExpressions(false);
        }
    }

    public String getName(FaceletContext ctx) {
        return this.name.getValue(ctx);
    }

    public ValueExpression getValue(FaceletContext ctx) {
        return this.value.getValueExpression(ctx, Object.class);
    }
}

