/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;

public final class HtmlJavaScriptUtils {
    private static final Logger log = Logger.getLogger(HtmlJavaScriptUtils.class.getName());
    private static final String AUTO_SCROLL_PARAM = "autoScroll";
    private static final String AUTO_SCROLL_FUNCTION = "getScrolling";
    private static final String SET_HIDDEN_INPUT_FN_NAME = "oamSetHiddenInput";
    private static final String SET_HIDDEN_INPUT_FN_NAME_JSF2 = "myfaces.oam.setHiddenInput";
    private static final String FIRST_SUBMIT_SCRIPT_ON_PAGE = "org.apache.MyFaces.FIRST_SUBMIT_SCRIPT_ON_PAGE";
    private static final String CLEAR_HIDDEN_INPUT_FN_NAME = "oamClearHiddenInput";

    public static void renderFormSubmitScript(FacesContext facesContext) throws IOException {
        if (facesContext.getPartialViewContext() != null && (facesContext.getPartialViewContext().isPartialRequest() || facesContext.getPartialViewContext().isAjaxRequest())) {
            return;
        }
        Map<String, Object> map = facesContext.getExternalContext().getRequestMap();
        Boolean firstScript = (Boolean)map.get(FIRST_SUBMIT_SCRIPT_ON_PAGE);
        if (firstScript == null || firstScript.equals(Boolean.TRUE)) {
            map.put(FIRST_SUBMIT_SCRIPT_ON_PAGE, Boolean.FALSE);
            HtmlJavaScriptUtils.renderFormSubmitScriptIfNecessary(facesContext);
            HtmlJavaScriptUtils.renderConfigOptionsIfNecessary(facesContext);
        }
    }

    private static void renderFormSubmitScriptIfNecessary(FacesContext facesContext) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        ResourceUtils.renderMyfacesJSInlineIfNecessary(facesContext, writer);
    }

    private static void renderConfigOptionsIfNecessary(FacesContext facesContext) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        MyfacesConfig config = MyfacesConfig.getCurrentInstance(facesContext.getExternalContext());
        HtmlRendererUtils.ScriptContext script = new HtmlRendererUtils.ScriptContext();
        boolean autoScroll = config.isAutoScroll();
        boolean autoSave = JavascriptUtils.isSaveFormSubmitLinkIE(facesContext.getExternalContext());
        if (autoScroll || autoSave) {
            script.prettyLine();
            script.increaseIndent();
            script.append("(!window.myfaces) ? window.myfaces = {} : null;");
            script.append("(!myfaces.core) ? myfaces.core = {} : null;");
            script.append("(!myfaces.core.config) ? myfaces.core.config = {} : null;");
        }
        if (autoScroll) {
            script.append("myfaces.core.config.autoScroll = true;");
        }
        if (autoSave) {
            script.append("myfaces.core.config.ieAutoSave = true;");
        }
        if (autoScroll || autoSave) {
            writer.startElement("script", null);
            writer.writeAttribute("type", "text/javascript", null);
            writer.writeText(script.toString(), null);
            writer.endElement("script");
        }
    }

    public static void appendAutoScrollAssignment(StringBuilder onClickValue, String formName) {
        HtmlJavaScriptUtils.appendAutoScrollAssignment(FacesContext.getCurrentInstance(), new HtmlRendererUtils.ScriptContext(onClickValue, false), formName);
    }

    public static void appendAutoScrollAssignment(FacesContext context, StringBuilder onClickValue, String formName) {
        HtmlJavaScriptUtils.appendAutoScrollAssignment(context, new HtmlRendererUtils.ScriptContext(onClickValue, false), formName);
    }

    private static void appendAutoScrollAssignment(FacesContext context, HtmlRendererUtils.ScriptContext scriptContext, String formName) {
        String formNameStr = formName == null ? "formName" : "'" + formName + "'";
        String paramName = "'" + AUTO_SCROLL_PARAM + "'";
        String value = AUTO_SCROLL_FUNCTION + "()";
        scriptContext.prettyLine();
        scriptContext.append("if(typeof window.getScrolling!='undefined')");
        scriptContext.append("{");
        scriptContext.append(SET_HIDDEN_INPUT_FN_NAME_JSF2);
        scriptContext.append("(").append(formNameStr).append(",").append(paramName).append(",").append(value).append(");");
        scriptContext.append("}");
    }

    public static String getAutoScrollFunction(FacesContext facesContext) {
        String scrolling;
        HtmlRendererUtils.ScriptContext script = new HtmlRendererUtils.ScriptContext();
        script.prettyLineIncreaseIndent();
        script.append("function ");
        script.append(AUTO_SCROLL_FUNCTION);
        script.append("()");
        script.append("{");
        script.append("var x = 0; var y = 0;");
        script.append("if (self.pageXOffset || self.pageYOffset)");
        script.append("{");
        script.append("x = self.pageXOffset;");
        script.prettyLine();
        script.append("y = self.pageYOffset;");
        script.append("}");
        script.append(" else if ((document.documentElement && document.documentElement.scrollLeft)||(document.documentElement && document.documentElement.scrollTop))");
        script.append("{");
        script.append("x = document.documentElement.scrollLeft;");
        script.prettyLine();
        script.append("y = document.documentElement.scrollTop;");
        script.append("}");
        script.append(" else if (document.body) ");
        script.append("{");
        script.append("x = document.body.scrollLeft;");
        script.prettyLine();
        script.append("y = document.body.scrollTop;");
        script.append("}");
        script.append("return x + \",\" + y;");
        script.append("}");
        ExternalContext externalContext = facesContext.getExternalContext();
        String oldViewId = JavascriptUtils.getOldViewId(externalContext);
        if (oldViewId != null && oldViewId.equals(facesContext.getViewRoot().getViewId()) && (scrolling = externalContext.getRequestParameterMap().get(AUTO_SCROLL_PARAM)) != null && scrolling.length() > 0) {
            double x = 0.0;
            double y = 0.0;
            int comma = scrolling.indexOf(44);
            if (comma == -1) {
                log.warning("Illegal autoscroll request parameter: " + scrolling);
            } else {
                try {
                    x = Double.parseDouble(scrolling.substring(0, comma));
                }
                catch (NumberFormatException e) {
                    log.warning("Error getting x offset for autoscroll feature. Bad param value: " + scrolling);
                    x = 0.0;
                }
                try {
                    y = Integer.parseInt(scrolling.substring(comma + 1));
                }
                catch (NumberFormatException e) {
                    log.warning("Error getting y offset for autoscroll feature. Bad param value: " + scrolling);
                    y = 0.0;
                }
            }
            script.append("window.scrollTo(").append(String.valueOf(x)).append(",").append(String.valueOf(y)).append(");\n");
        }
        return script.toString();
    }

    public static void renderAutoScrollHiddenInput(FacesContext facesContext, ResponseWriter writer) throws IOException {
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", null);
        writer.writeAttribute("name", AUTO_SCROLL_PARAM, null);
        writer.endElement("input");
    }

    public static void renderAutoScrollFunction(FacesContext facesContext, ResponseWriter writer) throws IOException {
        writer.startElement("script", null);
        writer.writeAttribute("type", "text/javascript", null);
        writer.writeText(HtmlJavaScriptUtils.getAutoScrollFunction(facesContext), null);
        writer.endElement("script");
    }

    public static void appendClearHiddenCommandFormParamsFunctionCall(StringBuilder buf, String formName) {
        HtmlJavaScriptUtils.appendClearHiddenCommandFormParamsFunctionCall(new HtmlRendererUtils.ScriptContext(buf, false), formName);
    }

    private static void appendClearHiddenCommandFormParamsFunctionCall(HtmlRendererUtils.ScriptContext context, String formName) {
        String functionName = HtmlRendererUtils.getClearHiddenCommandFormParamsFunctionName(formName);
        if (formName == null) {
            context.prettyLine();
            context.append("var clearFn = ");
            context.append(functionName);
            context.append(";");
            context.prettyLine();
            context.append("if(typeof window[clearFn] =='function')");
            context.append("{");
            context.append("window[clearFn](formName);");
            context.append("}");
        } else {
            context.prettyLine();
            context.append("if(typeof window.");
            context.append(functionName);
            context.append("=='function')");
            context.append("{");
            context.append(functionName).append("('").append(formName).append("');");
            context.append("}");
        }
    }

    public static String getClearHiddenCommandFormParamsFunctionName(String formName) {
        char separatorChar = FacesContext.getCurrentInstance().getNamingContainerSeparatorChar();
        if (formName == null) {
            return "'clearFormHiddenParams_'+formName.replace(/-/g, '\\$" + separatorChar + "').replace(/" + separatorChar + "/g,'_')";
        }
        return JavascriptUtils.getValidJavascriptNameAsInRI("clearFormHiddenParams_" + formName.replace(separatorChar, '_'));
    }

    public static String getClearHiddenCommandFormParamsFunctionNameMyfacesLegacy(String formName) {
        return "clear_" + JavascriptUtils.getValidJavascriptName(formName, false);
    }

    public static void renderClearHiddenCommandFormParamsFunction(ResponseWriter writer, String formName, Set dummyFormParams, String formTarget) throws IOException {
        String functionName = HtmlJavaScriptUtils.getClearHiddenCommandFormParamsFunctionName(formName);
        writer.startElement("script", null);
        writer.writeAttribute("type", "text/javascript", null);
        StringBuilder script = new StringBuilder();
        script.append("function ");
        script.append(functionName);
        script.append("() {");
        if (dummyFormParams != null) {
            script.append("\n  var f = document.forms['");
            script.append(formName);
            script.append("'];");
            int i = 0;
            Iterator it = dummyFormParams.iterator();
            while (it.hasNext()) {
                String elemVarName = "elem" + i;
                script.append("\n  var ").append(elemVarName).append(" = ");
                script.append("f.elements['").append((String)it.next()).append("'];");
                script.append("\n  if(typeof ").append(elemVarName).append(" !='undefined' && ");
                script.append(elemVarName).append(".nodeName=='INPUT'){");
                script.append("\n   if (").append(elemVarName).append(".value != '') {");
                script.append("\n    " + elemVarName + ".value='';");
                script.append("\n   }");
                script.append("\n  }");
                ++i;
            }
        }
        script.append("\n  f.target=");
        if (formTarget == null || formTarget.length() == 0) {
            script.append("'';");
        } else {
            script.append("'");
            script.append(formTarget);
            script.append("';");
        }
        script.append("\n}");
        script.append("\n");
        script.append(functionName);
        script.append("();");
        writer.writeText(script.toString(), null);
        writer.endElement("script");
    }

    public static String escapeJavaScriptForChain(String javaScript) {
        StringBuilder out = null;
        for (int pos = 0; pos < javaScript.length(); ++pos) {
            char c = javaScript.charAt(pos);
            if (c == '\\' || c == '\'') {
                if (out == null) {
                    out = new StringBuilder(javaScript.length() + 8);
                    if (pos > 0) {
                        out.append(javaScript, 0, pos);
                    }
                }
                out.append('\\');
            }
            if (out == null) continue;
            out.append(c);
        }
        if (out == null) {
            return javaScript;
        }
        return out.toString();
    }
}

