/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import java.util.Collection;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;

public class ValidatorException
extends FacesException {
    private static final long serialVersionUID = 5965885122446047949L;
    private FacesMessage _facesMessage;
    private Collection<FacesMessage> _facesMessages;

    public ValidatorException(Collection<FacesMessage> messages) {
        super(ValidatorException.facesMessagesToString(messages));
        this._facesMessages = messages;
    }

    public ValidatorException(Collection<FacesMessage> messages, Throwable cause) {
        super(ValidatorException.facesMessagesToString(messages), cause);
        this._facesMessages = messages;
    }

    public ValidatorException(FacesMessage message) {
        super(ValidatorException.facesMessageToString(message));
        this._facesMessage = message;
    }

    public ValidatorException(FacesMessage message, Throwable cause) {
        super(ValidatorException.facesMessageToString(message), cause);
        this._facesMessage = message;
    }

    public FacesMessage getFacesMessage() {
        return this._facesMessage;
    }

    public Collection<FacesMessage> getFacesMessages() {
        return this._facesMessages;
    }

    private static String facesMessageToString(FacesMessage message) {
        String summary = message.getSummary();
        String detail = message.getDetail();
        if (summary != null) {
            if (detail != null && !detail.isEmpty()) {
                return summary + ": " + detail;
            }
            return summary;
        }
        return detail != null ? detail : "";
    }

    private static String facesMessagesToString(Collection<FacesMessage> messages) {
        if (messages == null || messages.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String separator = "";
        for (FacesMessage message : messages) {
            if (message == null) continue;
            String summary = message.getSummary();
            String detail = message.getDetail();
            if (summary == null) continue;
            sb.append(separator);
            sb.append(summary);
            if (detail != null && !detail.isEmpty()) {
                sb.append(": ");
                sb.append(detail);
            }
            separator = ", ";
        }
        return sb.toString();
    }
}

