/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.view;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import java.io.Serializable;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.myfaces.cdi.JsfApplicationArtifactHolder;
import org.apache.myfaces.cdi.view.ViewScopeContextImpl;
import org.apache.myfaces.cdi.view.ViewScopeContextualStorage;
import org.apache.myfaces.context.ReleaseableExternalContext;
import org.apache.myfaces.context.servlet.StartupFacesContextImpl;
import org.apache.myfaces.context.servlet.StartupServletExternalContextImpl;
import org.apache.myfaces.shared.context.ExceptionHandlerImpl;

@SessionScoped
public class ViewScopeBeanHolder
implements Serializable {
    private Map<String, ViewScopeContextualStorage> storageMap;
    private static final Random RANDOM_GENERATOR = new Random();
    private static final String VIEW_SCOPE_PREFIX = "oam.view.SCOPE";
    public static final String VIEW_SCOPE_PREFIX_KEY = "oam.view.SCOPE.KEY";
    @Inject
    JsfApplicationArtifactHolder applicationContextBean;

    @PostConstruct
    public void init() {
        this.storageMap = new ConcurrentHashMap<String, ViewScopeContextualStorage>();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.getExternalContext().getSessionMap().put(VIEW_SCOPE_PREFIX_KEY, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewScopeContextualStorage getContextualStorage(BeanManager beanManager, String viewScopeId) {
        ViewScopeContextualStorage contextualStorage = this.storageMap.get(viewScopeId);
        if (contextualStorage == null) {
            ViewScopeBeanHolder viewScopeBeanHolder = this;
            synchronized (viewScopeBeanHolder) {
                contextualStorage = this.storageMap.get(viewScopeId);
                if (contextualStorage == null) {
                    contextualStorage = new ViewScopeContextualStorage(beanManager);
                    this.storageMap.put(viewScopeId, contextualStorage);
                }
            }
        }
        return contextualStorage;
    }

    public Map<String, ViewScopeContextualStorage> getStorageMap() {
        return this.storageMap;
    }

    public Map<String, ViewScopeContextualStorage> forceNewStorage() {
        Map<String, ViewScopeContextualStorage> oldStorageMap = this.storageMap;
        this.storageMap = new ConcurrentHashMap<String, ViewScopeContextualStorage>();
        return oldStorageMap;
    }

    public void destroyBeans() {
        Map<String, ViewScopeContextualStorage> oldWindowContextStorages = this.forceNewStorage();
        for (ViewScopeContextualStorage contextualStorage : oldWindowContextStorages.values()) {
            ViewScopeContextImpl.destroyAllActive(contextualStorage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyBeans(String viewScopeId) {
        block8: {
            ViewScopeContextualStorage contextualStorage = this.storageMap.get(viewScopeId);
            if (contextualStorage != null) {
                try {
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    if (facesContext == null && this.applicationContextBean.getServletContext() != null) {
                        try {
                            ServletContext servletContext = this.applicationContextBean.getServletContext();
                            StartupServletExternalContextImpl externalContext = new StartupServletExternalContextImpl(servletContext, false);
                            ExceptionHandlerImpl exceptionHandler = new ExceptionHandlerImpl();
                            facesContext = new StartupFacesContextImpl((ExternalContext)externalContext, (ReleaseableExternalContext)externalContext, exceptionHandler, false);
                            ViewScopeContextImpl.destroyAllActive(contextualStorage, facesContext);
                            break block8;
                        }
                        finally {
                            facesContext.release();
                        }
                    }
                    ViewScopeContextImpl.destroyAllActive(contextualStorage, facesContext);
                }
                finally {
                    this.storageMap.remove(viewScopeId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void destroyBeansOnPreDestroy() {
        Map<String, ViewScopeContextualStorage> oldWindowContextStorages = this.forceNewStorage();
        if (!oldWindowContextStorages.isEmpty()) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext == null && this.applicationContextBean.getServletContext() != null) {
                try {
                    ServletContext servletContext = this.applicationContextBean.getServletContext();
                    StartupServletExternalContextImpl externalContext = new StartupServletExternalContextImpl(servletContext, false);
                    ExceptionHandlerImpl exceptionHandler = new ExceptionHandlerImpl();
                    facesContext = new StartupFacesContextImpl((ExternalContext)externalContext, (ReleaseableExternalContext)externalContext, exceptionHandler, false);
                    for (ViewScopeContextualStorage contextualStorage : oldWindowContextStorages.values()) {
                        ViewScopeContextImpl.destroyAllActive(contextualStorage, facesContext);
                    }
                }
                finally {
                    facesContext.release();
                }
            } else {
                for (ViewScopeContextualStorage contextualStorage : oldWindowContextStorages.values()) {
                    ViewScopeContextImpl.destroyAllActive(contextualStorage);
                }
            }
        }
    }

    public String generateUniqueViewScopeId() {
        String key;
        while (this.storageMap.containsKey(key = Integer.toString(RANDOM_GENERATOR.nextInt()))) {
        }
        return key;
    }

    public void removeStorage(String viewScopeId) {
        this.storageMap.remove(viewScopeId);
    }
}

