/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.property.DefaultPropertyInformation;
import org.apache.myfaces.extensions.validator.core.property.PropertyDetails;
import org.apache.myfaces.extensions.validator.core.property.PropertyInformation;
import org.apache.myfaces.extensions.validator.core.storage.PropertyStorage;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.REUSE})
public class ExtValAnnotationUtils {
    private static final Logger LOGGER = Logger.getLogger(ExtValAnnotationUtils.class.getName());

    @ToDo(value=Priority.HIGH, description="add cache")
    public static PropertyInformation extractAnnotations(Class entityClass, PropertyDetails propertyDetails) {
        DefaultPropertyInformation propertyInformation = new DefaultPropertyInformation();
        propertyInformation.setInformation("property_details", propertyDetails);
        PropertyStorage storage = ReflectionUtils.getPropertyStorage();
        while (!Object.class.getName().equals(entityClass.getName())) {
            ExtValAnnotationUtils.addPropertyAccessAnnotations(storage, entityClass, propertyDetails.getProperty(), propertyInformation);
            ExtValAnnotationUtils.addFieldAccessAnnotations(storage, entityClass, propertyDetails.getProperty(), propertyInformation);
            ExtValAnnotationUtils.processInterfaces(storage, entityClass, propertyDetails, propertyInformation);
            entityClass = entityClass.getSuperclass();
        }
        return propertyInformation;
    }

    @ToDo(value=Priority.HIGH, description="add cache")
    public static void addPropertyAccessAnnotations(PropertyStorage storage, Class entity, String property, PropertyInformation propertyInformation) {
        Method method = ReflectionUtils.tryToGetMethodOfProperty(storage, entity, property);
        if (method != null) {
            ExtValAnnotationUtils.addAnnotationToAnnotationEntries(Arrays.asList(method.getAnnotations()), propertyInformation);
        }
    }

    @ToDo(value=Priority.HIGH, description="add cache")
    public static void addFieldAccessAnnotations(PropertyStorage storage, Class entity, String property, PropertyInformation propertyInformation) {
        Field field = ReflectionUtils.tryToGetFieldOfProperty(storage, entity, property);
        if (field != null) {
            ExtValAnnotationUtils.addAnnotationToAnnotationEntries(Arrays.asList(field.getAnnotations()), propertyInformation);
        }
    }

    private static void processInterfaces(PropertyStorage storage, Class currentClass, PropertyDetails propertyDetails, PropertyInformation propertyInformation) {
        for (Class<?> currentInterface : currentClass.getInterfaces()) {
            ExtValAnnotationUtils.addPropertyAccessAnnotations(storage, currentInterface, propertyDetails.getProperty(), propertyInformation);
            ExtValAnnotationUtils.processInterfaces(storage, currentInterface, propertyDetails, propertyInformation);
        }
    }

    private static void addAnnotationToAnnotationEntries(List<Annotation> annotations, PropertyInformation propertyInformation) {
        for (Annotation annotation : annotations) {
            propertyInformation.addMetaDataEntry(ExtValAnnotationUtils.createMetaDataEntryForAnnotation(annotation));
            LOGGER.finest(annotation.getClass().getName() + " found");
        }
    }

    private static MetaDataEntry createMetaDataEntryForAnnotation(Annotation foundAnnotation) {
        MetaDataEntry entry = new MetaDataEntry();
        entry.setKey(foundAnnotation.annotationType().getName());
        entry.setValue(foundAnnotation);
        return entry;
    }

    public static <T> T extractValueOf(Annotation annotation, Class<T> targetClass) {
        for (Method annotationMethod : annotation.annotationType().getDeclaredMethods()) {
            if (!"value".equals(annotationMethod.getName())) continue;
            try {
                return (T)annotationMethod.invoke((Object)annotation, new Object[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }
}

