/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.component.UITreeSelect;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUITree;
import org.apache.myfaces.tobago.model.Selectable;
import org.apache.myfaces.tobago.renderkit.CommandRendererBase;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeListboxNodeRenderer
extends CommandRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TreeListboxNodeRenderer.class);

    @Override
    public void decode(FacesContext facesContext, UIComponent component) {
        UITreeNode node = (UITreeNode)component;
        super.decode(facesContext, (UIComponent)node);
        if (ComponentUtils.isOutputOnly((UIComponent)node)) {
            return;
        }
        AbstractUITree tree = (AbstractUITree)ComponentUtils.findAncestor((UIComponent)node, AbstractUITree.class);
        if (tree == null) {
            LOG.warn("No AbstractUITree found as ancestor.");
            return;
        }
        String treeId = tree.getClientId(facesContext);
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String id = node.getClientId(facesContext);
        boolean folder = node.isFolder();
        if (tree.getSelectableAsEnum() != Selectable.NONE) {
            String selected = (String)requestParameterMap.get(treeId + "-selectState");
            String searchString = ";" + node.getClientId(facesContext) + ";";
            UITreeSelect treeSelect = (UITreeSelect)ComponentUtils.findDescendant((UIComponent)node, UITreeSelect.class);
            if (treeSelect != null) {
                treeSelect.setSubmittedValue((Object)selected.contains(searchString));
            }
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeNode node = (UITreeNode)component;
        UITreeSelect select = (UITreeSelect)ComponentUtils.findDescendant((UIComponent)node, UITreeSelect.class);
        AbstractUIData data = (AbstractUIData)ComponentUtils.findAncestor((UIComponent)node, AbstractUIData.class);
        String id = node.getClientId(facesContext);
        boolean selected = select != null && data != null && select.isValueStoredInState() ? data.getSelectedState().isSelected(node.getPath()) : "true".equals(this.getCurrentValue(facesContext, (UIComponent)select));
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.startElement("option", null);
        writer.writeAttribute("value", id, true);
        String title = node.getTip();
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        writer.writeIdAttribute(id);
        writer.writeAttribute("selected", selected);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeNode node = (UITreeNode)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        boolean folder = node.isFolder();
        if (folder) {
            writer.writeText(" \u2192");
        }
        writer.endElement("option");
    }
}

