/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.Validator;
import org.apache.myfaces.tobago.component.UITime;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.util.DateFormatUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.InputRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeRenderer
extends InputRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TimeRenderer.class);

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        super.prepareRender(facesContext, component);
        if (!TobagoConfig.getInstance((FacesContext)facesContext).isClassicDateTimePicker()) {
            UITime time = (UITime)component;
            Markup markup = time.getCurrentMarkup();
            markup = markup.add(Markup.valueOf((String)"timepicker"));
            time.setCurrentMarkup(markup);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UITime time = (UITime)component;
        String id = time.getClientId(facesContext);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)time);
        String currentValue = this.getCurrentValue(facesContext, (UIComponent)time);
        if (LOG.isDebugEnabled()) {
            LOG.debug("currentValue = '" + currentValue + "'");
        }
        boolean readonly = time.isReadonly();
        boolean disabled = time.isDisabled();
        boolean required = time.isRequired();
        Object value = time.getValue();
        Date date = value instanceof Date ? (Date)value : (value instanceof Calendar ? ((Calendar)value).getTime() : new Date());
        TobagoConfig tobagoConfig = TobagoConfig.getInstance((FacesContext)facesContext);
        if (tobagoConfig.isClassicDateTimePicker()) {
            String string;
            Converter converter;
            String pattern = "HH:mm";
            if (time.getConverter() != null && (converter = time.getConverter()) instanceof DateTimeConverter && (string = DateFormatUtils.findPattern((DateTimeConverter)((DateTimeConverter)converter))) != null && string.indexOf(115) > -1) {
                pattern = pattern + ":ss";
            }
            boolean hasSeconds = pattern.indexOf(115) > -1;
            String hour = new SimpleDateFormat("HH").format(date);
            String minute = new SimpleDateFormat("mm").format(date);
            String second = new SimpleDateFormat("ss").format(date);
            String idPrefix = id + "::";
            TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
            writer.startElement("div", (UIComponent)time);
            writer.writeIdAttribute(id);
            writer.writeClassAttribute(Classes.create((UIComponent)time));
            HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)time);
            writer.writeAttribute("data-tobago-classic-date-time-picker", "", false);
            Style style = new Style(facesContext, (LayoutBase)time);
            writer.writeStyleAttribute(style);
            String dateInputId = (String)time.getAttributes().get("dateInputId");
            if (dateInputId != null) {
                writer.writeAttribute("data-tobago-date-input-id", dateInputId, false);
            }
            writer.writeAttribute("data-tobago-pattern", pattern, true);
            writer.startElement("div", (UIComponent)time);
            writer.writeIdAttribute(idPrefix + "borderDiv");
            Markup markup = time.getCurrentMarkup();
            if (hasSeconds) {
                markup = markup.add(Markup.SECONDS);
            }
            writer.writeClassAttribute(Classes.create((UIComponent)time, (String)"borderDiv", (Markup)markup));
            this.writeInput(writer, time, idPrefix, "hour", hour, title, 24);
            this.writeInputSeparator(writer, time, ":");
            this.writeInput(writer, time, idPrefix, "minute", minute, title, 60);
            if (hasSeconds) {
                this.writeInputSeparator(writer, time, ":");
                this.writeInput(writer, time, idPrefix, "second", second, title, 60);
            }
            writer.endElement("div");
            writer.startElement("img", null);
            writer.writeIdAttribute(idPrefix + "inc");
            writer.writeClassAttribute(Classes.create((UIComponent)time, (String)"incImage", (Markup)markup));
            writer.writeAttribute("src", ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/timeIncrement"), true);
            writer.writeAttribute("alt", "", false);
            writer.writeAttribute("readonly", time.isReadonly());
            writer.writeAttribute("disabled", time.isDisabled());
            writer.endElement("img");
            writer.startElement("img", null);
            writer.writeIdAttribute(idPrefix + "dec");
            writer.writeClassAttribute(Classes.create((UIComponent)time, (String)"decImage", (Markup)markup));
            writer.writeAttribute("src", ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/timeDecrement"), true);
            writer.writeAttribute("alt", "", false);
            writer.writeAttribute("readonly", time.isReadonly());
            writer.writeAttribute("disabled", time.isDisabled());
            writer.endElement("img");
            writer.startElement("input", (UIComponent)time);
            writer.writeAttribute("type", "hidden", false);
            writer.writeIdAttribute(idPrefix + "field");
            writer.writeNameAttribute(id);
            writer.writeAttribute("value", hour + ":" + minute + ":" + second, false);
            writer.endElement("input");
            writer.endElement("div");
        } else {
            String pattern = null;
            Converter help = this.getConverter(facesContext, (UIComponent)time);
            if (help instanceof DateTimeConverter) {
                DateTimeConverter converter = (DateTimeConverter)help;
                pattern = DateFormatUtils.findPattern((DateTimeConverter)converter);
            }
            if (pattern == null) {
                pattern = "HH-mm";
                LOG.warn("Can't find the pattern for the converter! DatePicker may not work correctly. Trying to use: '" + pattern + "'");
            }
            TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
            writer.startElement("input", (UIComponent)time);
            writer.writeAttribute("type", "text", false);
            writer.writeNameAttribute(id);
            writer.writeIdAttribute(id);
            HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)time);
            if (currentValue != null) {
                writer.writeAttribute("value", currentValue, true);
            }
            if (title != null) {
                writer.writeAttribute("title", title, true);
            }
            int maxLength = 0;
            for (Validator validator : time.getValidators()) {
                if (!(validator instanceof LengthValidator)) continue;
                LengthValidator lengthValidator = (LengthValidator)validator;
                maxLength = lengthValidator.getMaximum();
            }
            if (maxLength > 0) {
                writer.writeAttribute("maxlength", maxLength);
            }
            writer.writeAttribute("data-tobago-pattern", pattern, true);
            writer.writeAttribute("readonly", readonly);
            writer.writeAttribute("disabled", disabled);
            Integer tabIndex = time.getTabIndex();
            if (tabIndex != null) {
                writer.writeAttribute("tabindex", tabIndex.intValue());
            }
            Style style = new Style(facesContext, (LayoutBase)time);
            writer.writeStyleAttribute(style);
            String placeholder = time.getPlaceholder();
            if (!disabled && !readonly && StringUtils.isNotBlank((String)placeholder)) {
                writer.writeAttribute("placeholder", placeholder, true);
            }
            writer.writeAttribute("autocomplete", "off", false);
            writer.writeClassAttribute(Classes.create((UIComponent)time));
            writer.writeAttribute("required", required);
            HtmlRendererUtils.renderFocus(id, time.isFocus(), ComponentUtils.isError((UIInput)time), facesContext, writer);
            HtmlRendererUtils.renderCommandFacet((UIComponent)time, facesContext, writer);
            String icon = ResourceManagerUtils.getImage((FacesContext)facesContext, (String)"image/time");
            if (icon != null) {
                writer.writeAttribute("data-tobago-date-time-icon", icon, true);
            }
            writer.endElement("input");
        }
    }

    private void writeInputSeparator(TobagoResponseWriter writer, UITime time, String sep) throws IOException {
        writer.startElement("span", null);
        writer.writeClassAttribute(Classes.create((UIComponent)time, (String)"sep"));
        writer.writeText(sep);
        writer.endElement("span");
    }

    private void writeInput(TobagoResponseWriter writer, UITime input, String idPrefix, String unit, String value, String title, int max) throws IOException {
        Integer tabIndex = input.getTabIndex();
        writer.startElement("input", null);
        writer.writeAttribute("type", "text", false);
        writer.writeIdAttribute(idPrefix + unit);
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        writer.writeAttribute("title", title, true);
        writer.writeClassAttribute(Classes.create((UIComponent)input, (String)"input"));
        writer.writeAttribute("readonly", input.isReadonly());
        writer.writeAttribute("disabled", input.isDisabled());
        writer.writeAttribute("value", value, true);
        writer.writeAttribute("data-tobago-max", Integer.toString(max), true);
        writer.writeAttribute("data-tobago-unit", unit, true);
        writer.endElement("input");
    }
}

