/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.ThemeImpl;
import org.apache.myfaces.tobago.exception.TobagoConfigurationException;
import org.apache.myfaces.tobago.internal.config.ContentSecurityPolicy;
import org.apache.myfaces.tobago.internal.config.SecurityAnnotation;
import org.apache.myfaces.tobago.sanitizer.Sanitizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TobagoConfigImpl
extends TobagoConfig {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoConfigImpl.class);
    private List<Theme> supportedThemes;
    private List<String> supportedThemeNames = new ArrayList<String>();
    private Theme defaultTheme;
    private String defaultThemeName;
    private Map<String, ThemeImpl> availableThemes;
    private boolean createSessionSecret = true;
    private boolean checkSessionSecret = true;
    private boolean preventFrameAttacks = true;
    private ContentSecurityPolicy contentSecurityPolicy;
    private SecurityAnnotation securityAnnotation;
    private boolean setNosniffHeader = true;
    private Map<String, String> defaultValidatorInfo;
    private Sanitizer sanitizer;
    private boolean decodeLineFeed = true;
    private Map<String, String> mimeTypes;
    private boolean unmodifiable = false;

    protected TobagoConfigImpl() {
        this.supportedThemes = new ArrayList<Theme>();
        this.availableThemes = new HashMap<String, ThemeImpl>();
        this.securityAnnotation = SecurityAnnotation.disable;
        this.contentSecurityPolicy = new ContentSecurityPolicy(ContentSecurityPolicy.Mode.OFF.getValue());
        this.mimeTypes = new HashMap<String, String>();
    }

    protected void lock() {
        this.unmodifiable = true;
        this.supportedThemes = Collections.unmodifiableList(this.supportedThemes);
        for (Theme theme : this.supportedThemes) {
            ((ThemeImpl)theme).lock();
        }
        this.supportedThemeNames = Collections.unmodifiableList(this.supportedThemeNames);
        this.availableThemes = Collections.unmodifiableMap(this.availableThemes);
        this.contentSecurityPolicy.lock();
        this.mimeTypes = Collections.unmodifiableMap(this.mimeTypes);
    }

    private void checkLocked() throws IllegalStateException {
        if (this.unmodifiable) {
            throw new TobagoConfigurationException("The configuration must not be changed after initialization!");
        }
    }

    protected void addSupportedThemeName(String name) {
        this.checkLocked();
        this.supportedThemeNames.add(name);
    }

    protected void resolveThemes() {
        this.checkLocked();
        if (this.defaultThemeName != null) {
            this.defaultTheme = this.availableThemes.get(this.defaultThemeName);
            this.checkThemeIsAvailable(this.defaultThemeName, this.defaultTheme);
            if (LOG.isDebugEnabled()) {
                LOG.debug("name = '{}'", (Object)this.defaultThemeName);
                LOG.debug("defaultTheme = '{}'", (Object)this.defaultTheme);
            }
        } else {
            int deep = 0;
            for (Map.Entry<String, ThemeImpl> entry : this.availableThemes.entrySet()) {
                Theme theme = entry.getValue();
                if (theme.getFallbackList().size() <= deep) continue;
                this.defaultTheme = theme;
                deep = theme.getFallbackList().size();
            }
            if (this.defaultTheme == null) {
                String error = "Did not found any theme! Please ensure you have a tobago-config.xml with a theme-definition in your theme JAR. Please add a theme JAR to your WEB-INF/lib";
                LOG.error("Did not found any theme! Please ensure you have a tobago-config.xml with a theme-definition in your theme JAR. Please add a theme JAR to your WEB-INF/lib");
                throw new TobagoConfigurationException("Did not found any theme! Please ensure you have a tobago-config.xml with a theme-definition in your theme JAR. Please add a theme JAR to your WEB-INF/lib");
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Using default Theme {}", (Object)this.defaultTheme.getName());
            }
        }
        if (!this.supportedThemeNames.isEmpty()) {
            for (String name : this.supportedThemeNames) {
                Theme theme = this.availableThemes.get(name);
                this.checkThemeIsAvailable(name, theme);
                this.supportedThemes.add(theme);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("name = '{}'", (Object)name);
                LOG.debug("supportedThemes.last() = '{}'", (Object)this.supportedThemes.get(this.supportedThemes.size() - 1));
            }
        }
    }

    private void checkThemeIsAvailable(String name, Theme theme) {
        if (theme == null) {
            String error = "Theme not found! name: '" + name + "'. Please ensure you have a tobago-config.xml with a theme-definition in your theme JAR. Found the following themes: " + this.availableThemes.keySet();
            LOG.error(error);
            throw new TobagoConfigurationException(error);
        }
    }

    @Override
    public Theme getTheme(String name) {
        if (name == null) {
            LOG.debug("searching theme: null");
            return this.defaultTheme;
        }
        if (this.defaultTheme != null && this.defaultTheme.getName().equals(name)) {
            return this.defaultTheme;
        }
        for (Theme theme : this.supportedThemes) {
            if (!theme.getName().equals(name)) continue;
            return theme;
        }
        LOG.debug("searching theme '{}' not found. Using default: {}", (Object)name, (Object)this.defaultTheme);
        return this.defaultTheme;
    }

    protected void setDefaultThemeName(String defaultThemeName) {
        this.checkLocked();
        this.defaultThemeName = defaultThemeName;
    }

    @Override
    public List<Theme> getSupportedThemes() {
        return this.supportedThemes;
    }

    @Override
    public Theme getDefaultTheme() {
        return this.defaultTheme;
    }

    protected void addAvailableTheme(ThemeImpl availableTheme) {
        this.checkLocked();
        this.availableThemes.put(availableTheme.getName(), availableTheme);
    }

    public Map<String, ThemeImpl> getAvailableThemes() {
        return this.availableThemes;
    }

    @Override
    @Deprecated
    public ProjectStage getProjectStage() {
        return FacesContext.getCurrentInstance().getApplication().getProjectStage();
    }

    protected synchronized void initDefaultValidatorInfo() {
        FacesContext facesContext;
        if (this.defaultValidatorInfo != null) {
            this.checkLocked();
        }
        if ((facesContext = FacesContext.getCurrentInstance()) != null) {
            try {
                Application application = facesContext.getApplication();
                Map map = application.getDefaultValidatorInfo();
                this.defaultValidatorInfo = map.size() > 0 ? Collections.unmodifiableMap(map) : Collections.emptyMap();
            }
            catch (Exception e) {
                LOG.error("Can't initialize default validators (this happens with JBoss GateIn 3.6.0).", (Throwable)e);
                this.defaultValidatorInfo = Collections.emptyMap();
            }
        }
    }

    @Override
    public boolean isCreateSessionSecret() {
        return this.createSessionSecret;
    }

    protected void setCreateSessionSecret(boolean createSessionSecret) {
        this.checkLocked();
        this.createSessionSecret = createSessionSecret;
    }

    @Override
    public boolean isCheckSessionSecret() {
        return this.checkSessionSecret;
    }

    protected void setCheckSessionSecret(boolean checkSessionSecret) {
        this.checkLocked();
        this.checkSessionSecret = checkSessionSecret;
    }

    @Override
    public boolean isPreventFrameAttacks() {
        return this.preventFrameAttacks;
    }

    protected void setPreventFrameAttacks(boolean preventFrameAttacks) {
        this.checkLocked();
        this.preventFrameAttacks = preventFrameAttacks;
    }

    @Override
    public ContentSecurityPolicy getContentSecurityPolicy() {
        return this.contentSecurityPolicy;
    }

    @Override
    public boolean isSetNosniffHeader() {
        return this.setNosniffHeader;
    }

    protected void setSetNosniffHeader(boolean setNosniffHeader) {
        this.checkLocked();
        this.setNosniffHeader = setNosniffHeader;
    }

    @Override
    public SecurityAnnotation getSecurityAnnotation() {
        return this.securityAnnotation;
    }

    public void setSecurityAnnotation(SecurityAnnotation securityAnnotation) {
        this.checkLocked();
        this.securityAnnotation = securityAnnotation;
    }

    public Map<String, String> getDefaultValidatorInfo() {
        if (this.defaultValidatorInfo == null) {
            this.initDefaultValidatorInfo();
        }
        return this.defaultValidatorInfo;
    }

    @Override
    public Sanitizer getSanitizer() {
        return this.sanitizer;
    }

    protected void setSanitizer(Sanitizer sanitizer) {
        this.checkLocked();
        this.sanitizer = sanitizer;
    }

    @Override
    public boolean isDecodeLineFeed() {
        return this.decodeLineFeed;
    }

    public void setDecodeLineFeed(boolean decodeLineFeed) {
        this.checkLocked();
        this.decodeLineFeed = decodeLineFeed;
    }

    @Override
    public Map<String, String> getMimeTypes() {
        return this.mimeTypes;
    }

    @Override
    @Deprecated
    public boolean isClassicDateTimePicker() {
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TobagoConfigImpl{");
        builder.append("\nsupportedThemes=[");
        for (Theme supportedTheme : this.supportedThemes) {
            builder.append(supportedTheme.getName());
            builder.append(", ");
        }
        builder.append("], \ndefaultTheme=");
        builder.append(this.defaultTheme != null ? this.defaultTheme.getName() : null);
        builder.append(", \navailableThemes=");
        builder.append(this.availableThemes.keySet());
        builder.append(", \ncreateSessionSecret=");
        builder.append(this.createSessionSecret);
        builder.append(", \ncheckSessionSecret=");
        builder.append(this.checkSessionSecret);
        builder.append(", \npreventFrameAttacks=");
        builder.append(this.preventFrameAttacks);
        builder.append(", \ncontentSecurityPolicy=");
        builder.append(this.contentSecurityPolicy);
        builder.append(", \nsecurityAnnotation=");
        builder.append((Object)this.securityAnnotation);
        builder.append(", \nsetNosniffHeader=");
        builder.append(this.setNosniffHeader);
        builder.append(", \ndefaultValidatorInfo=");
        builder.append(this.defaultValidatorInfo);
        builder.append(", \nsanitizer=");
        builder.append(this.sanitizer);
        builder.append(", \ndecodeLineFeed=");
        builder.append(this.decodeLineFeed);
        builder.append(", \nthemes=");
        HashSet<ThemeImpl> all = new HashSet<ThemeImpl>(this.availableThemes.values());
        builder.append(all);
        builder.append(", \nmimeTypes=");
        builder.append(this.mimeTypes);
        builder.append('}');
        return builder.toString();
    }
}

