/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.component.Tags;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIGridLayout;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.MeasureList;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlRoleValues;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class GridLayoutRenderer<T extends AbstractUIGridLayout>
extends RendererBase<T> {
    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        Markup markup = component.getMarkup();
        writer.startElement(HtmlElements.TOBAGO_GRID_LAYOUT);
        writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.PRESENTATION.toString(), false);
        writer.writeIdAttribute(component.getClientId(facesContext));
        writer.writeClassAttribute(markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null);
        MeasureList columns = MeasureList.parse(((AbstractUIGridLayout)component).getColumns());
        MeasureList rows = MeasureList.parse(((AbstractUIGridLayout)component).getRows());
        AbstractUIStyle style = (AbstractUIStyle)facesContext.getApplication().createComponent(facesContext, Tags.style.componentType(), RendererTypes.Style.name());
        style.setTransient(true);
        if (columns.stream().anyMatch(measure -> Measure.Unit.AUTO.equals((Object)measure.getUnit())) && columns.stream().noneMatch(measure -> Measure.Unit.FR.equals((Object)measure.getUnit()))) {
            columns.add(new Measure(1, Measure.Unit.FR));
        }
        style.setGridTemplateColumns(columns.serialize());
        style.setGridTemplateRows(rows.serialize());
        component.getChildren().add(style);
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.TOBAGO_GRID_LAYOUT);
    }
}

