/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.trace;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.shared_tomahawk.trace.Closure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracingSupport {
    private static final Object[] EMPTY_PARAMS = new Object[0];
    private Logger _logger;
    private Level _level = Level.FINE;
    private String _sourceClass;

    public TracingSupport() {
        this(Logger.getAnonymousLogger());
    }

    public TracingSupport(Class clazz) {
        this(clazz.getName());
    }

    public TracingSupport(String className) {
        this(Logger.getLogger(className));
    }

    public TracingSupport(Logger logger) {
        this._logger = logger;
        this._sourceClass = logger.getName();
    }

    public Level getLevel() {
        return this._level;
    }

    public void setLevel(Level level) {
        if (level == null) {
            throw new IllegalArgumentException("log level can not be null");
        }
        this._level = level;
    }

    public <T> T trace(String methodName, Closure<T> closure) {
        return this.trace(methodName, closure, EMPTY_PARAMS);
    }

    public <T> T trace(String methodName, Closure<T> closure, Object ... params) {
        if (this._logger.isLoggable(this._level)) {
            this._logger.logp(this._level, this._sourceClass, methodName, "ENTRY" + this.prepareParams(params), params);
            try {
                T result = closure.call();
                if (!Void.class.equals(result)) {
                    this._logger.logp(this._level, this._sourceClass, methodName, "RETURN {0}", result);
                } else {
                    this._logger.logp(this._level, this._sourceClass, methodName, "RETURN");
                }
                return result;
            }
            catch (RuntimeException e) {
                this._logger.logp(this._level, this._sourceClass, methodName, "THROW", e);
                throw e;
            }
        }
        return closure.call();
    }

    private String prepareParams(Object[] params) {
        if (params == null || params.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(" ");
        int size = params.length;
        for (int i = 0; i < size; ++i) {
            builder.append("{");
            builder.append(i);
            builder.append("}");
            if (i + 1 >= size) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public Logger getLogger() {
        return this._logger;
    }

    public void setLogger(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger must not be null");
        }
        this._logger = logger;
    }

    public String getSourceClass() {
        return this._sourceClass;
    }

    public void setSourceClass(String className) {
        if (className == null) {
            throw new IllegalArgumentException("className must not be null");
        }
        this._sourceClass = className;
    }
}

