/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.component.html.util.StreamingAddResource;

public class StreamingThreadManager {
    public static final String KEY = "org.apache.myfaces.component.html.util.StreamingThreadManager";
    private final Map headerInfos = new HashMap();
    private Thread cleanupThread = null;
    private CleanupThread cleanupThreadObject = null;
    private volatile long REQUEST_ID_COUNTER = 0L;

    public void init() {
        if (this.cleanupThread == null) {
            this.cleanupThreadObject = new CleanupThread();
            this.cleanupThread = new Thread((Runnable)this.cleanupThreadObject, "StreamingAddResource.CleanupThread");
            this.cleanupThread.setDaemon(true);
            this.cleanupThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.cleanupThread != null) {
            this.cleanupThreadObject.done();
            this.cleanupThread.interrupt();
            this.cleanupThread = null;
            Map map = this.headerInfos;
            synchronized (map) {
                this.headerInfos.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderInfoEntry getHeaderInfo(Long requestId) {
        Map map = this.headerInfos;
        synchronized (map) {
            return (HeaderInfoEntry)this.headerInfos.get(requestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long putNewHeaderInfoEntry() {
        Long requestId = null;
        StreamingThreadManager streamingThreadManager = this;
        synchronized (streamingThreadManager) {
            ++this.REQUEST_ID_COUNTER;
            requestId = new Long(this.REQUEST_ID_COUNTER);
        }
        HeaderInfoEntry headerInfoEntry = new HeaderInfoEntry();
        Map map = this.headerInfos;
        synchronized (map) {
            this.headerInfos.put(requestId, headerInfoEntry);
        }
        return requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHeaderInfo(Long requestId) {
        Map map = this.headerInfos;
        synchronized (map) {
            this.headerInfos.remove(requestId);
        }
    }

    private class CleanupThread
    implements Runnable {
        private static final int CHECKS_PER_RUN = 10;
        private static final int CACHE_LIMIT = 1000;
        private boolean threadDone = false;

        private CleanupThread() {
        }

        public void run() {
            while (!Thread.interrupted() && !this.threadDone) {
                this.checkMap();
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void done() {
            this.threadDone = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkMap() {
            Map map = StreamingThreadManager.this.headerInfos;
            synchronized (map) {
                long now = System.currentTimeMillis();
                int checkNo = 0;
                Iterator iterEntries = StreamingThreadManager.this.headerInfos.entrySet().iterator();
                while (iterEntries.hasNext() && !Thread.currentThread().isInterrupted()) {
                    if (StreamingThreadManager.this.headerInfos.size() < 1000 && ++checkNo > 10) {
                        return;
                    }
                    Map.Entry entry = iterEntries.next();
                    HeaderInfoEntry headerInfoEntry = (HeaderInfoEntry)entry.getValue();
                    if (!headerInfoEntry.isDestroyable(now)) continue;
                    iterEntries.remove();
                }
            }
        }
    }

    public static class HeaderInfoEntry {
        private final long destroyTime = System.currentTimeMillis() + 60000L;
        private final List addedInfos = new ArrayList(10);
        private volatile boolean requestDone = false;

        protected HeaderInfoEntry() {
        }

        protected boolean isDestroyable(long now) {
            return this.destroyTime < now;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addInfo(StreamingAddResource.StreamablePositionedInfo positionedInfo) {
            List list = this.addedInfos;
            synchronized (list) {
                this.addedInfos.add(positionedInfo);
                this.addedInfos.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected StreamingAddResource.StreamablePositionedInfo fetchInfo() throws InterruptedException {
            List list = this.addedInfos;
            synchronized (list) {
                while (this.addedInfos.size() < 1 && !this.requestDone) {
                    this.addedInfos.wait(100L);
                }
                if (this.addedInfos.size() < 1) {
                    return null;
                }
                return (StreamingAddResource.StreamablePositionedInfo)this.addedInfos.remove(0);
            }
        }

        protected void setRequestDone() {
            this.requestDone = true;
        }
    }
}

