/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.agent.parse;

import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidadinternal.agent.parse.IncludeNode;
import org.apache.myfaces.trinidadinternal.agent.parse.NameVersion;
import org.apache.myfaces.trinidadinternal.agent.parse.VersionId;

class CapabilitiesNode {
    NameVersion _agent;
    NameVersion _platform;
    private String _id;
    private boolean _isDefault = false;
    private IncludeNode[] _nodesWithRef;
    private IncludeNode[] _nodesWithSrc;

    public CapabilitiesNode(String id, boolean isDefault, NameVersion agent, NameVersion platform, IncludeNode[] nodesWithRef, IncludeNode[] nodesWithSrc) {
        this._id = id;
        this._isDefault = isDefault;
        this._agent = agent;
        this._platform = platform;
        this._nodesWithRef = nodesWithRef;
        this._nodesWithSrc = nodesWithSrc;
    }

    String __getId() {
        return this._id;
    }

    boolean __isDefault() {
        return this._isDefault;
    }

    void setNodesWithRef(IncludeNode[] nodesWithRef) {
        this._nodesWithRef = nodesWithRef;
    }

    void __setNodesWithSrc(IncludeNode[] nodesWithSrc) {
        this._nodesWithSrc = nodesWithSrc;
    }

    IncludeNode[] __getIncludesByUri() {
        return this._nodesWithSrc;
    }

    IncludeNode[] __getIncludesByRef() {
        return this._nodesWithRef;
    }

    double __matches(Agent agent) {
        double agentScore = 0.0;
        if (this._agent != null && (agentScore = this._getAgentMatch(agent)) <= 0.0) {
            return 0.0;
        }
        double platformScore = 0.0;
        if (this._platform != null && (platformScore = this._getPlatformMatch(agent)) <= 0.0) {
            return 0.0;
        }
        return agentScore * 10000.0 + platformScore;
    }

    private double _getPlatformMatch(Agent agent) {
        String platName = agent.getPlatformName();
        String version = agent.getPlatformVersion();
        VersionId platVersionId = null;
        if (version != null) {
            platVersionId = new VersionId(version);
        }
        return this._platform.match(platName, platVersionId);
    }

    private double _getAgentMatch(Agent agent) {
        String agentName = agent.getAgentName();
        String version = agent.getAgentVersion();
        VersionId agentVersionId = null;
        if (version != null) {
            agentVersionId = new VersionId(version);
        }
        return this._agent.match(agentName, agentVersionId);
    }
}

