/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.output.CoreSpacer;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class SpacerRenderer
extends XhtmlRenderer {
    private PropertyKey _heightKey;
    private PropertyKey _widthKey;

    public SpacerRenderer() {
        super(CoreSpacer.TYPE);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._heightKey = type.findKey("height");
        this._widthKey = type.findKey("width");
    }

    protected void encodeBegin(FacesContext context, RenderingContext arc, UIComponent comp, FacesBean bean) throws IOException {
        String id = this.shouldRenderId(context, comp) ? this.getClientId(context, comp) : null;
        String width = this.getWidth(bean);
        String height = this.getHeight(bean);
        if (width == null) {
            if (height == null) {
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement("span", comp);
                writer.writeAttribute("id", (Object)id, null);
                writer.endElement("span");
            } else {
                this.renderVerticalSpacer(context, height, id, comp);
            }
        } else {
            this.renderDecorativeIcon(context, arc, "t.gif", width, height, id, null, comp);
        }
    }

    protected String getHeight(FacesBean bean) {
        return SpacerRenderer.toString((Object)bean.getProperty(this._heightKey));
    }

    protected String getWidth(FacesBean bean) {
        return SpacerRenderer.toString((Object)bean.getProperty(this._widthKey));
    }
}

