/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.taglib;

import javax.faces.component.EditableValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.validator.Validator;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public final class ValidatorTag
extends TagSupport {
    private String _validatorId = null;
    private String _binding = null;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ValidatorTag.class);

    public void setValidatorId(String validatorId) {
        this._validatorId = validatorId;
    }

    public void setBinding(String binding) {
        this._binding = binding;
    }

    public int doStartTag() throws JspException {
        UIComponentTag tag = UIComponentTag.getParentUIComponentTag((PageContext)this.pageContext);
        if (tag == null) {
            _LOG.severe("VALIDATOR_NOT_INSIDE_UICOMPONENT");
            return 0;
        }
        if (tag.getCreated()) {
            Validator validator = this.createValidator();
            if (validator != null) {
                EditableValueHolder evh = (EditableValueHolder)tag.getComponentInstance();
                evh.addValidator(validator);
            } else {
                _LOG.warning("CANNOT_CREATE_VALIDATOR", (Object[])new String[]{this._validatorId, this._binding});
            }
        }
        return 0;
    }

    public void release() {
        super.release();
        this._validatorId = null;
        this._binding = null;
    }

    protected Validator createValidator() throws JspException {
        Validator validator;
        ValueBinding binding;
        FacesContext context = FacesContext.getCurrentInstance();
        if (this._binding != null) {
            binding = context.getApplication().createValueBinding(this._binding);
            validator = (Validator)binding.getValue(context);
            if (validator != null) {
                return validator;
            }
        } else {
            binding = null;
        }
        if (this._validatorId != null) {
            validator = context.getApplication().createValidator(this._validatorId);
            if (binding != null) {
                binding.setValue(context, (Object)validator);
            }
            return validator;
        }
        _LOG.severe("MISSING_VALIDATORID");
        return null;
    }
}

