/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.bean.util;

import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.bean.PropertyMap;
import org.apache.myfaces.trinidad.bean.util.StateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyHashMap
extends HashMap<PropertyKey, Object>
implements PropertyMap {
    private transient boolean _initialStateMarked;
    private transient PropertyMap _deltas;
    private boolean _useStateHolder;
    private static final long serialVersionUID = 1L;

    public PropertyHashMap(PropertyMap map) {
        super(map);
    }

    public PropertyHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public PropertyHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public PropertyHashMap() {
    }

    @Override
    public Object put(PropertyKey key, Object value) {
        Object retValue = super.put(key, value);
        if (this._createDeltas() && !PropertyHashMap._equals(value, retValue)) {
            this._deltas.put(key, value);
        }
        return retValue;
    }

    @Override
    public Object remove(Object key) {
        if (this._createDeltas()) {
            if (!super.containsKey(key)) {
                return null;
            }
            assert (key instanceof PropertyKey);
            this._deltas.put((PropertyKey)key, null);
        }
        return super.remove(key);
    }

    @Override
    public void putAll(Map<? extends PropertyKey, ? extends Object> t) {
        if (this._createDeltas()) {
            this._deltas.putAll(t);
        }
        super.putAll(t);
    }

    @Override
    public Object saveState(FacesContext context) {
        if (this._initialStateMarked) {
            if (this._deltas == null) {
                return null;
            }
            return StateUtils.saveState(this._deltas, context, this.getUseStateHolder());
        }
        return StateUtils.saveState(this, context, this.getUseStateHolder());
    }

    @Override
    public void restoreState(FacesContext context, FacesBean.Type type, Object state) {
        StateUtils.restoreState(this, context, type, state, this.getUseStateHolder());
    }

    protected PropertyMap createDeltaPropertyMap() {
        PropertyHashMap map = new PropertyHashMap(2);
        map.setUseStateHolder(this.getUseStateHolder());
        return map;
    }

    public boolean getUseStateHolder() {
        return this._useStateHolder;
    }

    public void setUseStateHolder(boolean useStateHolder) {
        this._useStateHolder = useStateHolder;
    }

    @Override
    public void markInitialState() {
        this._initialStateMarked = true;
    }

    private boolean _createDeltas() {
        if (this._initialStateMarked) {
            if (this._deltas == null) {
                this._deltas = this.createDeltaPropertyMap();
            }
            return true;
        }
        return false;
    }

    private static boolean _equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }
}

