/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.render.Renderer;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.FlattenedComponent;
import org.apache.myfaces.trinidad.component.StampState;
import org.apache.myfaces.trinidad.component.TableRowEvent;
import org.apache.myfaces.trinidad.component.TableUtils;
import org.apache.myfaces.trinidad.component.UIXColumn;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.component.ValueMap;
import org.apache.myfaces.trinidad.component.visit.VisitCallback;
import org.apache.myfaces.trinidad.component.visit.VisitContext;
import org.apache.myfaces.trinidad.component.visit.VisitHint;
import org.apache.myfaces.trinidad.component.visit.VisitResult;
import org.apache.myfaces.trinidad.event.SelectionEvent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.LocalRowKeyIndex;
import org.apache.myfaces.trinidad.model.SortCriterion;
import org.apache.myfaces.trinidad.render.ClientRowKeyManager;
import org.apache.myfaces.trinidad.render.ClientRowKeyManagerFactory;
import org.apache.myfaces.trinidad.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIXCollection
extends UIXComponentBase
implements NamingContainer {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXComponentBase.TYPE);
    public static final PropertyKey VAR_KEY = TYPE.registerKey("var", String.class, 1);
    private InternalState _state = null;
    private static final Object _NULL = new Object();
    private static final String _INVOKE_KEY = UIXCollection.class.getName() + ".INVOKE";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(UIXCollection.class);

    protected UIXCollection(String rendererType) {
        super(rendererType);
    }

    protected UIXCollection() {
        this(null);
    }

    public final String getVar() {
        return ComponentUtils.resolveString(this.getProperty(VAR_KEY));
    }

    public final void setVar(String var) {
        this.setProperty(VAR_KEY, var);
        InternalState iState = this._getInternalState(false);
        if (iState != null) {
            iState._var = var;
        }
    }

    @Override
    public void queueEvent(FacesEvent event) {
        if (event.getSource() == this && !(event instanceof SelectionEvent)) {
            InternalState iState = this._getInternalState(true);
            iState._hasEvent = true;
        }
        Object currencyKey = this.getRowKey();
        event = new TableRowEvent(this, event, currencyKey);
        super.queueEvent(event);
    }

    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof TableRowEvent) {
            TableRowEvent rowEvent = (TableRowEvent)event;
            Object old = this.getRowKey();
            this.setRowKey(rowEvent.getCurrencyKey());
            FacesEvent wrapped = rowEvent.getEvent();
            wrapped.getComponent().broadcast(wrapped);
            this.setRowKey(old);
        } else {
            super.broadcast(event);
        }
    }

    @Override
    public final void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this._init();
        InternalState iState = this._getInternalState(true);
        iState._isFirstRender = false;
        if (!this.isRendered()) {
            return;
        }
        this._flushCachedModel();
        iState._hasEvent = false;
        this.decode(context);
        this.decodeChildren(context);
    }

    @Override
    protected void decodeChildrenImpl(FacesContext context) {
        this.processFacetsAndChildren(context, PhaseId.APPLY_REQUEST_VALUES);
    }

    @Override
    protected void validateChildrenImpl(FacesContext context) {
        this.processFacetsAndChildren(context, PhaseId.PROCESS_VALIDATIONS);
    }

    @Override
    protected void updateChildrenImpl(FacesContext context) {
        this.processFacetsAndChildren(context, PhaseId.UPDATE_MODEL_VALUES);
    }

    public void resetStampState() {
        InternalState iState = this._getInternalState(true);
        Object initKey = this._getCurrencyKeyForInitialStampState();
        if (iState._stampState != null) {
            iState._stampState.clear(initKey);
        }
    }

    @Override
    public Object processSaveState(FacesContext context) {
        InternalState iState;
        Object initKey;
        Object currencyKey = this._getCurrencyKey();
        if (currencyKey != (initKey = this._getCurrencyKeyForInitialStampState())) {
            this.setRowKey(initKey);
        }
        Object savedState = super.processSaveState(context);
        if (currencyKey != initKey) {
            this.setRowKey(currencyKey);
        }
        if ((iState = this._getInternalState(false)) != null) {
            iState._value = null;
            iState._model = null;
        }
        return savedState;
    }

    @Override
    public Object saveState(FacesContext context) {
        ClientRowKeyManager clientKeyMgr;
        StampState stampState;
        Object superState = super.saveState(context);
        InternalState iState = this._getInternalState(false);
        if (iState != null) {
            stampState = iState._stampState;
            clientKeyMgr = iState._clientKeyMgr;
        } else {
            stampState = null;
            clientKeyMgr = null;
        }
        if (superState != null || stampState != null || clientKeyMgr != null) {
            return new Object[]{superState, stampState, clientKeyMgr};
        }
        return null;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object clientKeyMgr;
        Object stampState;
        Object superState;
        Object[] array = (Object[])state;
        if (array != null) {
            superState = array[0];
            stampState = array[1];
            clientKeyMgr = array[2];
        } else {
            superState = null;
            stampState = null;
            clientKeyMgr = null;
        }
        super.restoreState(context, superState);
        if (stampState != null || clientKeyMgr != null) {
            InternalState iState = this._getInternalState(true);
            iState._stampState = (StampState)stampState;
            iState._clientKeyMgr = (ClientRowKeyManager)clientKeyMgr;
        } else {
            InternalState iState = this._getInternalState(false);
            if (iState != null) {
                iState._stampState = null;
                iState._clientKeyMgr = null;
            }
        }
    }

    public final boolean isRowAvailable() {
        return this.getCollectionModel().isRowAvailable();
    }

    public final boolean isRowAvailable(Object rowKey) {
        return this.getCollectionModel().isRowAvailable(rowKey);
    }

    public final Object getRowData(Object rowKey) {
        return this.getCollectionModel().getRowData(rowKey);
    }

    public final boolean areRowsAvailable(int rowCount) {
        return this.getCollectionModel().areRowsAvailable(rowCount);
    }

    public final boolean areRowsAvailable(int startIndex, int rowCount) {
        return this.getCollectionModel().areRowsAvailable(startIndex, rowCount);
    }

    public final boolean areRowsAvailable(Object startRowKey, int rowCount) {
        return this.getCollectionModel().areRowsAvailable(startRowKey, rowCount);
    }

    public final int getRowCount() {
        return this.getCollectionModel().getRowCount();
    }

    public final int getRowIndex() {
        return this.getCollectionModel().getRowIndex();
    }

    public final Object getRowKey() {
        InternalState iState = this._getInternalState(true);
        if (iState._currentRowKey == _NULL) {
            iState._currentRowKey = this.getCollectionModel().getRowKey();
        }
        return iState._currentRowKey;
    }

    public final Object getRowData() {
        CollectionModel model = this.getCollectionModel();
        return model.isRowAvailable() ? model.getRowData() : null;
    }

    public boolean isRowAvailable(int rowIndex) {
        return this.getCollectionModel().isRowAvailable(rowIndex);
    }

    public Object getRowData(int rowIndex) {
        return this.getCollectionModel().getRowData(rowIndex);
    }

    public abstract String getVarStatus();

    public void setRowKey(Object rowKey) {
        this.preRowDataChange();
        this.getCollectionModel().setRowKey(rowKey);
        this.postRowDataChange();
        if (_LOG.isFine() && rowKey != null && !this.isRowAvailable()) {
            _LOG.fine("no row available for rowKey:" + rowKey);
        }
    }

    public void setRowIndex(int rowIndex) {
        this.preRowDataChange();
        this.getCollectionModel().setRowIndex(rowIndex);
        this.postRowDataChange();
        if (_LOG.isFine() && rowIndex != -1 && !this.isRowAvailable()) {
            _LOG.fine("no row available for rowIndex:" + rowIndex);
        }
    }

    public final boolean isSortable(String property) {
        return this.getCollectionModel().isSortable(property);
    }

    public void setSortCriteria(List<SortCriterion> criteria) {
        this.getCollectionModel().setSortCriteria(criteria);
    }

    public final List<SortCriterion> getSortCriteria() {
        return this.getCollectionModel().getSortCriteria();
    }

    @Deprecated
    protected void clearCurrencyStringCache() {
        this._getInternalState(true)._clearTokenCache = true;
    }

    @Override
    public final void encodeBegin(FacesContext context) throws IOException {
        this._init();
        InternalState istate = this._getInternalState(true);
        if (istate._clearTokenCache) {
            istate._clearTokenCache = false;
            ClientRowKeyManager keyMgr = this.getClientRowKeyManager();
            if (keyMgr instanceof DefaultClientKeyManager) {
                ((DefaultClientKeyManager)keyMgr).clear();
            }
        }
        this._flushCachedModel();
        Object assertKey = null;
        if ($assertionsDisabled || (assertKey = this.getRowKey()) == null) {
            // empty if block
        }
        this.__encodeBegin(context);
        assert (this._assertKeyPreserved(assertKey)) : "CurrencyKey not preserved";
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        Object assertKey = null;
        if ($assertionsDisabled || (assertKey = this.getRowKey()) == null) {
            // empty if block
        }
        super.encodeEnd(context);
        assert (this._assertKeyPreserved(assertKey)) : "CurrencyKey not preserved";
    }

    private boolean _assertKeyPreserved(Object oldKey) {
        Object newKey = this.getRowKey();
        return oldKey != null ? oldKey.equals(newKey) : newKey == null;
    }

    void __encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
    }

    boolean __isFirstRender() {
        InternalState iState = this._getInternalState(true);
        return iState._isFirstRender;
    }

    @Deprecated
    public String getCurrencyString() {
        return this.getClientRowKey();
    }

    @Deprecated
    public void setCurrencyString(String currency) {
        this.setClientRowKey(currency);
    }

    public String getClientRowKey() {
        Object currencyObject = this._getCurrencyKey();
        if (currencyObject == null) {
            return null;
        }
        Object initKey = this._getCurrencyKeyForInitialStampState();
        if (UIXCollection._equals(currencyObject, initKey)) {
            return null;
        }
        FacesContext fc = FacesContext.getCurrentInstance();
        String key = this.getClientRowKeyManager().getClientRowKey(fc, this, currencyObject);
        return key;
    }

    private Object _getCurrencyKey() {
        InternalState iState = this._getInternalState(false);
        if (iState == null) {
            return null;
        }
        return iState._model != null ? this.getRowKey() : this._getCurrencyKeyForInitialStampState();
    }

    public void setClientRowKey(String clientRowKey) {
        if (clientRowKey == null) {
            this.setRowKey(this._getCurrencyKeyForInitialStampState());
            return;
        }
        FacesContext fc = FacesContext.getCurrentInstance();
        Object rowkey = this.getClientRowKeyManager().getRowKey(fc, this, clientRowKey);
        if (rowkey == null) {
            _LOG.severe("CANNOT_FIND_ROWKEY", clientRowKey);
        } else {
            this.setRowKey(rowkey);
        }
    }

    public final String getContainerClientId(FacesContext context) {
        String id = this.getClientId(context);
        String key = this.getClientRowKey();
        if (key != null) {
            StringBuilder bld = UIXCollection.__getSharedStringBuilder();
            bld.append(id).append(':').append(key);
            id = bld.toString();
        }
        return id;
    }

    protected final void preRowDataChange() {
        this._saveStampState();
        InternalState iState = this._getInternalState(true);
        iState._currentRowKey = UIXCollection._NULL;
    }

    protected final void postRowDataChange() {
        Object rowData = this.getRowData();
        if (_LOG.isFinest() && rowData == null) {
            _LOG.finest("rowData is null at rowIndex:" + this.getRowIndex() + " and currencyKey:" + this.getRowKey());
        }
        InternalState iState = this._getInternalState(true);
        if (rowData == null) {
            if (iState._prevVarValue != _NULL) {
                this._setELVar(iState._var, iState._prevVarValue);
                iState._prevVarValue = UIXCollection._NULL;
            }
            if (iState._prevVarStatus != _NULL) {
                this._setELVar(iState._varStatus, iState._prevVarStatus);
                iState._prevVarStatus = UIXCollection._NULL;
            }
        } else {
            if (iState._var != null) {
                Object oldData = this._setELVar(iState._var, rowData);
                if (iState._prevVarValue == _NULL) {
                    iState._prevVarValue = oldData;
                }
            }
            if (iState._varStatus != null && iState._prevVarStatus == _NULL) {
                Map<String, Object> varStatusMap = this.createVarStatusMap();
                iState._prevVarStatus = this._setELVar(iState._varStatus, varStatusMap);
            }
        }
        this._restoreStampState();
        List<UIComponent> stamps = this.getStamps();
        for (UIComponent stamp : stamps) {
            UIXComponent.clearCachedClientIds(stamp);
        }
    }

    protected List<UIComponent> getStamps() {
        return this.getChildren();
    }

    private Object _getCurrencyKeyForInitialStampState() {
        InternalState iState = this._getInternalState(false);
        if (iState == null) {
            return null;
        }
        Object rowKey = iState._initialStampStateKey;
        return rowKey == _NULL ? null : rowKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object saveStampState(FacesContext context, UIComponent stamp) {
        if (stamp.isTransient()) {
            return Transient.TRUE;
        }
        boolean needsTearDownContext = false;
        if (stamp instanceof FlattenedComponent && stamp instanceof UIXComponent) {
            ((UIXComponent)stamp).setupVisitingContext(context);
            needsTearDownContext = true;
        }
        Object[] state = null;
        try {
            Object childState;
            Object stampState = StampState.saveStampState(context, stamp);
            assert (!(stampState instanceof Object[]));
            int facetCount = this._getFacetCount(stamp);
            if (facetCount > 0) {
                boolean facetStateIsEmpty = true;
                Object[] facetState = null;
                Map facetMap = stamp.getFacets();
                int i = 0;
                for (Map.Entry entry : facetMap.entrySet()) {
                    Object singleFacetState = this.saveStampState(context, (UIComponent)entry.getValue());
                    if (singleFacetState == null || singleFacetState == Transient.TRUE) continue;
                    if (facetStateIsEmpty) {
                        facetStateIsEmpty = false;
                        facetState = new Object[facetCount * 2];
                    }
                    int base = i * 2;
                    assert (facetState != null);
                    facetState[base] = entry.getKey();
                    facetState[base + 1] = singleFacetState;
                    ++i;
                }
                if (!facetStateIsEmpty) {
                    if (i < facetCount) {
                        Object[] trimmed = new Object[i * 2];
                        System.arraycopy(facetState, 0, trimmed, 0, i * 2);
                        facetState = trimmed;
                    }
                    state = new Object[3];
                    state[2] = facetState;
                }
            }
            if ((childState = StampState.saveChildStampState(context, stamp, this)) != null) {
                if (state == null) {
                    state = new Object[2];
                }
                state[1] = childState;
            }
            if (state == null) {
                Object object = stampState;
                return object;
            }
            state[0] = stampState;
        }
        finally {
            if (needsTearDownContext) {
                ((UIXComponent)stamp).tearDownVisitingContext(context);
            }
        }
        return state;
    }

    protected void restoreStampState(FacesContext context, UIComponent stamp, Object stampState) {
        if (stampState == Transient.TRUE || stampState == null) {
            return;
        }
        if (!(stampState instanceof Object[])) {
            StampState.restoreStampState(context, stamp, stampState);
            return;
        }
        Object[] state = (Object[])stampState;
        int stateSize = state.length;
        assert (stateSize >= 1);
        StampState.restoreStampState(context, stamp, state[0]);
        if (stateSize >= 3) {
            Object[] facetStateArray = (Object[])state[2];
            assert (facetStateArray != null);
            for (int i = 0; i < facetStateArray.length; i += 2) {
                String facetName = (String)facetStateArray[i];
                Object facetState = facetStateArray[i + 1];
                if (facetState == Transient.TRUE) continue;
                this.restoreStampState(context, stamp.getFacet(facetName), facetState);
            }
        }
        if (stateSize >= 2) {
            StampState.restoreChildStampState(context, stamp, this, state[1]);
        }
    }

    protected final void processComponent(FacesContext context, UIComponent component, PhaseId phaseId) {
        if (component != null) {
            if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                component.processDecodes(context);
            } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                component.processValidators(context);
            } else if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                component.processUpdates(context);
            } else {
                throw new IllegalArgumentException(_LOG.getMessage("BAD_PHASEID", phaseId));
            }
        }
    }

    protected abstract void processFacetsAndChildren(FacesContext var1, PhaseId var2);

    protected final CollectionModel getCollectionModel() {
        return this.getCollectionModel(true);
    }

    public final ClientRowKeyManager getClientRowKeyManager() {
        InternalState iState = this._getInternalState(true);
        if (iState._clientKeyMgr == null) {
            FacesContext fc = FacesContext.getCurrentInstance();
            Renderer r = this.getRenderer(fc);
            iState._clientKeyMgr = r instanceof ClientRowKeyManagerFactory ? ((ClientRowKeyManagerFactory)r).createClientRowKeyManager(fc, this) : new DefaultClientKeyManager();
        }
        return iState._clientKeyMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        String thisClientId = this.getClientId(context);
        if (clientId.equals(thisClientId)) {
            if (!UIXCollection._getAndMarkFirstInvokeForRequest(context, clientId)) {
                this._init();
                this._flushCachedModel();
            }
            callback.invokeContextCallback(context, (UIComponent)this);
            return true;
        }
        int thisClientIdLength = thisClientId.length();
        if (clientId.startsWith(thisClientId) && clientId.charAt(thisClientIdLength) == ':') {
            this.setupVisitingContext(context);
            try {
                String postId;
                int sepIndex;
                if (!UIXCollection._getAndMarkFirstInvokeForRequest(context, thisClientId)) {
                    this._init();
                    this._flushCachedModel();
                }
                if ((sepIndex = (postId = clientId.substring(thisClientIdLength + 1)).indexOf(58)) < 0) {
                    boolean bl = this.invokeOnChildrenComponents(context, clientId, callback);
                    return bl;
                }
                String currencyString = postId.substring(0, sepIndex);
                Object rowKey = this.getClientRowKeyManager().getRowKey(context, this, currencyString);
                if (rowKey != null) {
                    Object oldRowKey = this.getRowKey();
                    try {
                        this.setRowKey(rowKey);
                        boolean bl = this.invokeOnChildrenComponents(context, clientId, callback);
                        return bl;
                    }
                    finally {
                        this.setRowKey(oldRowKey);
                    }
                }
                boolean bl = this.invokeOnChildrenComponents(context, clientId, callback);
                return bl;
            }
            finally {
                this.tearDownVisitingContext(context);
            }
        }
        return false;
    }

    @Override
    protected boolean visitChildren(VisitContext visitContext, VisitCallback callback) {
        return this.defaultVisitChildren(visitContext, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean defaultVisitChildren(VisitContext visitContext, VisitCallback callback) {
        boolean doneVisiting;
        int oldRowIndex = this.getRowIndex();
        this.setRowIndex(-1);
        try {
            doneVisiting = this.visitUnstampedFacets(visitContext, callback);
            if (!doneVisiting && !(doneVisiting = this._visitStampedColumnFacets(visitContext, callback))) {
                doneVisiting = this.visitData(visitContext, callback);
            }
        }
        finally {
            this.setRowIndex(oldRowIndex);
        }
        return doneVisiting;
    }

    protected boolean visitUnstampedFacets(VisitContext visitContext, VisitCallback callback) {
        if (this.getFacetCount() > 0) {
            for (UIComponent facet : this.getFacets().values()) {
                if (!UIXComponent.visitTree(visitContext, facet, callback)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _visitStampedColumnFacets(VisitContext visitContext, VisitCallback callback) {
        List<UIComponent> stamps = this.getStamps();
        if (!stamps.isEmpty()) {
            ColumnFacetsOnlyVisitContext columnVisitingContext = new ColumnFacetsOnlyVisitContext(visitContext);
            for (UIComponent stamp : stamps) {
                if (!UIXComponent.visitTree(columnVisitingContext, stamp, callback)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract boolean visitData(VisitContext var1, VisitCallback var2);

    protected final CollectionModel getCollectionModel(boolean createIfNull) {
        InternalState iState = this._getInternalState(true);
        if (iState._model == null && createIfNull) {
            this._init();
            iState._value = this.getValue();
            iState._model = this.createCollectionModel(null, iState._value);
            this.postCreateCollectionModel(iState._model);
            assert (iState._model != null);
        }
        if (iState._initialStampStateKey == _NULL && iState._model != null) {
            iState._initialStampStateKey = iState._model.getRowKey();
        }
        return iState._model;
    }

    protected abstract CollectionModel createCollectionModel(CollectionModel var1, Object var2);

    protected void postCreateCollectionModel(CollectionModel model) {
    }

    protected abstract Object getValue();

    protected Map<String, Object> createVarStatusMap() {
        return new AbstractMap<String, Object>(){

            @Override
            public Object get(Object key) {
                if ("model".equals(key)) {
                    return UIXCollection.this.getCollectionModel();
                }
                if ("rowKey".equals(key)) {
                    return UIXCollection.this.getRowKey();
                }
                if ("index".equals(key)) {
                    return UIXCollection.this.getRowIndex();
                }
                if ("current".equals(key)) {
                    return UIXCollection.this.getRowData();
                }
                return null;
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return Collections.emptySet();
            }
        };
    }

    public boolean isRowLocallyAvailable(int rowIndex) {
        return this.getCollectionModel().isRowLocallyAvailable(rowIndex);
    }

    public boolean isRowLocallyAvailable(Object rowKey) {
        return this.getCollectionModel().isRowLocallyAvailable(rowKey);
    }

    public boolean areRowsLocallyAvailable(int rowCount) {
        return this.getCollectionModel().areRowsLocallyAvailable(rowCount);
    }

    public boolean areRowsLocallyAvailable(int startIndex, int rowCount) {
        return this.getCollectionModel().areRowsLocallyAvailable(startIndex, rowCount);
    }

    public boolean areRowsLocallyAvailable(Object startRowKey, int rowCount) {
        return this.getCollectionModel().areRowsLocallyAvailable(startRowKey, rowCount);
    }

    public int getEstimatedRowCount() {
        return this.getCollectionModel().getEstimatedRowCount();
    }

    public LocalRowKeyIndex.Confidence getEstimatedRowCountConfidence() {
        return this.getCollectionModel().getEstimatedRowCountConfidence();
    }

    public void clearLocalCache() {
        this.getCollectionModel().clearLocalCache();
    }

    public void clearCachedRows(int startingIndex, int rowsToClear) {
        this.getCollectionModel().clearCachedRows(startingIndex, rowsToClear);
    }

    public void clearCachedRows(Object startingRowKey, int rowsToClear) {
        this.getCollectionModel().clearCachedRows(startingRowKey, rowsToClear);
    }

    public void clearCachedRow(int index) {
        this.getCollectionModel().clearCachedRow(index);
    }

    public void clearCachedRow(Object rowKey) {
        this.getCollectionModel().clearCachedRow(rowKey);
    }

    public LocalRowKeyIndex.LocalCachingStrategy getCachingStrategy() {
        return this.getCollectionModel().getCachingStrategy();
    }

    void __init() {
        InternalState iState = this._getInternalState(true);
        iState._var = this.getVar();
        if (_LOG.isFine() && iState._var == null) {
            _LOG.fine("'var' attribute is null.");
        }
        iState._varStatus = this.getVarStatus();
        if (_LOG.isFinest() && iState._varStatus == null) {
            _LOG.finest("'varStatus' attribute is null.");
        }
    }

    void __processFlattenedChildrenBegin() {
        this._init();
        this._flushCachedModel();
    }

    private void _init() {
        InternalState iState = this._getInternalState(true);
        if (!iState._isInitialized) {
            assert (iState._model == null);
            iState._isInitialized = true;
            this.__init();
        }
    }

    private void _flushCachedModel() {
        InternalState iState = this._getInternalState(true);
        Object value = this.getValue();
        if (iState._value != value) {
            iState._value = value;
            iState._model = this.createCollectionModel(iState._model, value);
            this.postCreateCollectionModel(iState._model);
        }
    }

    private static boolean _getAndMarkFirstInvokeForRequest(FacesContext context, String clientId) {
        String key;
        Map requestMap = context.getExternalContext().getRequestMap();
        if (requestMap.containsKey(key = _INVOKE_KEY + clientId)) {
            return true;
        }
        requestMap.put(key, Boolean.TRUE);
        return false;
    }

    Object __getMyStampState() {
        return this._state;
    }

    void __setMyStampState(Object stampState) {
        InternalState iState;
        this._state = iState = (InternalState)stampState;
    }

    boolean __hasEvent() {
        InternalState iState = this._getInternalState(true);
        return iState._hasEvent;
    }

    private void _saveStampState() {
        StampState stampState = this._getStampState();
        FacesContext context = this.getFacesContext();
        Object currencyObj = this.getRowKey();
        int position = 0;
        for (UIComponent stamp : this.getStamps()) {
            Object state = this.saveStampState(context, stamp);
            String stampId = String.valueOf(position++);
            stampState.put(currencyObj, stampId, state);
            if (!_LOG.isFinest()) continue;
            _LOG.finest("saving stamp state for currencyObject:" + currencyObj + " and stampId:" + stampId);
        }
    }

    private void _restoreStampState() {
        StampState stampState = this._getStampState();
        FacesContext context = this.getFacesContext();
        Object currencyObj = this.getRowKey();
        int position = 0;
        for (UIComponent stamp : this.getStamps()) {
            String stampId;
            Object state;
            if ((state = stampState.get(currencyObj, stampId = String.valueOf(position++))) == null) {
                Object iniStateObj = this._getCurrencyKeyForInitialStampState();
                state = stampState.get(iniStateObj, stampId);
            }
            this.restoreStampState(context, stamp, state);
        }
    }

    private InternalState _getInternalState(boolean create) {
        if (this._state == null && create) {
            this._state = new InternalState();
        }
        return this._state;
    }

    private StampState _getStampState() {
        InternalState iState = this._getInternalState(true);
        if (iState._stampState == null) {
            iState._stampState = new StampState();
        }
        return iState._stampState;
    }

    private Object _setELVar(String varName, Object newData) {
        if (varName == null) {
            return null;
        }
        return TableUtils.setupELVariable(this.getFacesContext(), varName, newData);
    }

    private static boolean _equals(Object a, Object b) {
        if (b == null) {
            return a == null;
        }
        return b.equals(a);
    }

    private int _getFacetCount(UIComponent component) {
        if (component instanceof UIXComponent) {
            return ((UIXComponent)component).getFacetCount();
        }
        return component.getFacets().size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Transient {
        TRUE;

    }

    private static final class InternalState
    implements Serializable {
        private transient boolean _hasEvent = false;
        private transient Object _prevVarValue = UIXCollection.access$1800();
        private transient Object _prevVarStatus = UIXCollection.access$1800();
        private transient String _var = null;
        private transient String _varStatus = null;
        private transient Object _value = null;
        private transient CollectionModel _model = null;
        private transient Object _currentRowKey = UIXCollection.access$1800();
        private transient boolean _clearTokenCache = false;
        private transient boolean _isFirstRender = true;
        private transient boolean _isInitialized = false;
        private transient Object _initialStampStateKey = UIXCollection.access$1800();
        private ClientRowKeyManager _clientKeyMgr = null;
        private StampState _stampState = null;
        private static final long serialVersionUID = 1L;

        private InternalState() {
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this._prevVarValue = _NULL;
            this._prevVarStatus = _NULL;
            this._currentRowKey = _NULL;
            this._initialStampStateKey = _NULL;
            this._isFirstRender = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultClientKeyManager
    extends ClientRowKeyManager {
        private ValueMap<Object, String> _currencyCache = new ValueMap();
        private static final long serialVersionUID = 1L;

        private DefaultClientKeyManager() {
        }

        public void clear() {
            this._currencyCache.clear();
        }

        @Override
        public Object getRowKey(FacesContext context, UIComponent component, String clientRowKey) {
            if (DefaultClientKeyManager._isOptimizedKey(clientRowKey)) {
                return clientRowKey;
            }
            ValueMap<Object, String> currencyCache = this._currencyCache;
            Object rowkey = currencyCache.getKey(clientRowKey);
            return rowkey;
        }

        @Override
        public String getClientRowKey(FacesContext context, UIComponent component, Object rowKey) {
            assert (rowKey != null);
            ValueMap<Object, String> currencyCache = this._currencyCache;
            String key = currencyCache.get(rowKey);
            if (key == null) {
                if (rowKey instanceof String && DefaultClientKeyManager._isOptimizedKey(key = rowKey.toString())) {
                    return key;
                }
                key = DefaultClientKeyManager._createToken(currencyCache);
                if (_LOG.isFiner()) {
                    _LOG.finer("Storing token:" + key + " for rowKey:" + rowKey);
                }
                currencyCache.put(rowKey, key);
            }
            return key;
        }

        private static boolean _isOptimizedKey(String key) {
            return key.length() > 0 && !Character.isDigit(key.charAt(0));
        }

        private static String _createToken(ValueMap<Object, String> currencyCache) {
            String key = String.valueOf(currencyCache.size());
            return key;
        }
    }

    protected static final class NoColumnFacetsVisitContext
    extends VisitContextWrapper {
        private final VisitContext _wrapped;

        NoColumnFacetsVisitContext(VisitContext wrapped) {
            this._wrapped = wrapped;
        }

        protected VisitContext getWrapped() {
            return this._wrapped;
        }

        public VisitResult invokeVisitCallback(UIComponent component, VisitCallback callback) {
            if (component instanceof UIXColumn) {
                if (component.getChildCount() > 0) {
                    for (UIComponent child : component.getChildren()) {
                        if (!UIXComponent.visitTree(this, child, callback)) continue;
                        return VisitResult.COMPLETE;
                    }
                }
                return VisitResult.REJECT;
            }
            if (UIXComponent.visitTree(this.getWrapped(), component, callback)) {
                return VisitResult.COMPLETE;
            }
            return VisitResult.REJECT;
        }
    }

    private static class ColumnFacetsOnlyVisitContext
    extends VisitContextWrapper {
        private final VisitContext _wrapped;

        public ColumnFacetsOnlyVisitContext(VisitContext wrappedContext) {
            this._wrapped = wrappedContext;
        }

        protected VisitContext getWrapped() {
            return this._wrapped;
        }

        public VisitResult invokeVisitCallback(UIComponent component, VisitCallback callback) {
            if (component instanceof UIXColumn && component.getFacetCount() > 0) {
                for (UIComponent facetChild : component.getFacets().values()) {
                    if (!UIXComponent.visitTree(this.getWrapped(), facetChild, callback)) continue;
                    return VisitResult.COMPLETE;
                }
                for (UIComponent child : component.getChildren()) {
                    if (!UIXComponent.visitTree(this, child, callback)) continue;
                    return VisitResult.COMPLETE;
                }
            }
            return VisitResult.REJECT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class VisitContextWrapper
    extends VisitContext {
        private VisitContextWrapper() {
        }

        protected abstract VisitContext getWrapped();

        @Override
        public FacesContext getFacesContext() {
            return this.getWrapped().getFacesContext();
        }

        @Override
        public PhaseId getPhaseId() {
            return this.getWrapped().getPhaseId();
        }

        @Override
        public Collection<String> getIdsToVisit() {
            return this.getWrapped().getIdsToVisit();
        }

        @Override
        public Collection<String> getSubtreeIdsToVisit(UIComponent component) {
            return this.getWrapped().getSubtreeIdsToVisit(component);
        }

        @Override
        public VisitResult invokeVisitCallback(UIComponent component, VisitCallback callback) {
            return this.getWrapped().invokeVisitCallback(component, callback);
        }

        @Override
        public Set<VisitHint> getHints() {
            return this.getWrapped().getHints();
        }
    }
}

