/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import org.apache.myfaces.trinidad.event.ReturnListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReturnEvent
extends FacesEvent {
    private Object _returnValue;
    private Map<Object, Object> _returnParams;
    private static final long serialVersionUID = 1L;

    public ReturnEvent(UIComponent source, Object returnValue) {
        this(source, returnValue, null);
    }

    public ReturnEvent(UIComponent source, Object returnValue, Map<Object, Object> returnParams) {
        super(source);
        this._returnValue = returnValue;
        this._returnParams = returnParams == null ? Collections.emptyMap() : new HashMap<Object, Object>(returnParams);
    }

    public Object getReturnValue() {
        return this._returnValue;
    }

    public Map<Object, Object> getReturnParameters() {
        return Collections.unmodifiableMap(this._returnParams);
    }

    public void processListener(FacesListener listener) {
        ((ReturnListener)listener).processReturn(this);
    }

    public boolean isAppropriateListener(FacesListener listener) {
        return listener instanceof ReturnListener;
    }

    public int hashCode() {
        return (this.getComponent() == null ? 0 : this.getComponent().hashCode()) + 37 * ((this._returnValue == null ? 0 : this._returnValue.hashCode()) + 37 * (this._returnParams == null ? 0 : this._returnParams.hashCode()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ReturnEvent) {
            ReturnEvent that = (ReturnEvent)((Object)o);
            if (!this.getComponent().equals(that.getComponent())) {
                return false;
            }
            if (this._returnValue == null ? that._returnValue != null : !this._returnValue.equals(that._returnValue)) {
                return false;
            }
            return !(this._returnParams == null ? that._returnParams != null : !this._returnParams.equals(that._returnParams));
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(((Object)((Object)this)).getClass().getName());
        sb.append("[component=");
        sb.append(this.getComponent());
        sb.append(", returnValue=");
        sb.append(this.getReturnValue());
        if (this._returnParams != null && !this._returnParams.isEmpty()) {
            sb.append(", returnParams=");
            sb.append(this._returnParams);
        }
        sb.append(']');
        return sb.toString();
    }
}

