/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(Service.class);

    public static <T> T getService(Object from, Class<T> serviceClass) {
        T o;
        if (from == null) {
            throw new NullPointerException();
        }
        if (from instanceof Provider && (o = ((Provider)from).getService(serviceClass)) != null) {
            if (!serviceClass.isAssignableFrom(o.getClass())) {
                throw new IllegalStateException(_LOG.getMessage("PROVIDER_NOT_RETURN_IMPLEMENTING_OBJECT", new Object[]{from, serviceClass.getName()}));
            }
            return o;
        }
        if (serviceClass.isAssignableFrom(from.getClass())) {
            return (T)from;
        }
        return null;
    }

    public static <T> T getRenderKitService(FacesContext context, Class<T> serviceClass) {
        RenderKit rk = context.getRenderKit();
        if (rk == null) {
            throw new NullPointerException(_LOG.getMessage("OBTAIN_NULL_RENDERKIT_WHILE_GETTING_SERVICE", serviceClass.getName()));
        }
        return Service.getService(rk, serviceClass);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Provider {
        public <T> T getService(Class<T> var1);
    }
}

