/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.io;

import java.io.IOException;
import java.io.Writer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidadinternal.io.ResponseWriterDecorator;

public class RepeatIdResponseWriter
extends ResponseWriterDecorator {
    private static String ID_SUFFIX = "_adfr";

    public static ResponseWriter install(FacesContext context) {
        ResponseWriter oldRW = context.getResponseWriter();
        RepeatIdResponseWriter newRW = new RepeatIdResponseWriter(oldRW);
        context.setResponseWriter((ResponseWriter)newRW);
        return oldRW;
    }

    public static void remove(FacesContext context, ResponseWriter oldRW) {
        context.setResponseWriter(oldRW);
    }

    private RepeatIdResponseWriter(ResponseWriter out) {
        super(out);
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return new RepeatIdResponseWriter(this.getResponseWriter().cloneWithWriter(writer));
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        super.writeAttribute(name, this._transformIdAndForValues(name, value), property);
    }

    private Object _transformIdAndForValues(String name, Object value) {
        if (value == null) {
            return null;
        }
        if ("id".equals(name) || "for".equals(name)) {
            String transformedId = value + ID_SUFFIX;
            return transformedId;
        }
        return value;
    }
}

