/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.html.HtmlScript;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class ScriptRenderer
extends XhtmlRenderer {
    private PropertyKey _sourceKey;
    private PropertyKey _textKey;
    private PropertyKey _generatesContentKey;

    public ScriptRenderer() {
        super(HtmlScript.TYPE);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._textKey = type.findKey("text");
        this._sourceKey = type.findKey("source");
        this._generatesContentKey = type.findKey("generatesContent");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("script", component);
        this.renderId(context, component);
        ScriptRenderer.renderScriptTypeAttribute(context, arc);
        if (!this.getGeneratesContent(component, bean)) {
            ScriptRenderer.renderScriptDeferAttribute(context, arc);
        }
        String source = this.getSource(context, component, bean);
        String text = this.getText(component, bean);
        if (source != null) {
            this.renderEncodedResourceURI(context, "src", source);
        } else if (text != null) {
            rw.writeText((Object)text, "text");
        }
        this.encodeAllChildren(context, component);
        rw.endElement("script");
        if (source != null && text != null) {
            rw.startElement("script", component);
            ScriptRenderer.renderScriptTypeAttribute(context, arc);
            if (!this.getGeneratesContent(component, bean)) {
                ScriptRenderer.renderScriptDeferAttribute(context, arc);
            }
            rw.writeText((Object)text, "text");
            rw.endElement("script");
        }
    }

    protected String getSource(FacesContext context, UIComponent component, FacesBean bean) {
        return ScriptRenderer.toResourceUri((FacesContext)context, (Object)bean.getProperty(this._sourceKey));
    }

    protected String getText(UIComponent component, FacesBean bean) {
        return ScriptRenderer.toString((Object)bean.getProperty(this._textKey));
    }

    protected boolean getGeneratesContent(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._generatesContentKey);
        if (o == null) {
            o = this._generatesContentKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }
}

