/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.pregen.config;

import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.AccessibilityProfile;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.EnumParseException;
import org.apache.myfaces.trinidad.util.Enums;
import org.apache.myfaces.trinidad.util.FileUtils;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderingContext;
import org.apache.myfaces.trinidadinternal.share.nls.NullLocaleContext;
import org.apache.myfaces.trinidadinternal.skin.pregen.config.InvalidConfigException;

public abstract class PregenConfig {
    public static final Collection<?> ALL_VARIANTS = new AbstractCollection(){

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }
    };
    private static final PregenConfig _NULL_CONFIG = new NullPregenConfig();
    private static final String _TARGET_DIRECTORY_PROPERTY = "org.apache.myfaces.trinidad.SKIN_PREGENERATION_SERVICE_TARGET_DIRECTORY";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(PregenConfig.class);

    public static PregenConfig nullInstance() {
        return _NULL_CONFIG;
    }

    public static PregenConfig parse(FacesContext context) throws InvalidConfigException {
        ExternalContext external = context.getExternalContext();
        return PregenConfig._isAllVariantsRequest(external) ? new AllPregenConfig(context) : new CommonPregenConfig(context);
    }

    private static boolean _isAllVariantsRequest(ExternalContext external) throws InvalidConfigException {
        Collection<Variants> variants = PregenConfig._parseDisplayNameParam(external, "variants", Variants.class, Variants.COMMON);
        return variants.contains((Object)Variants.ALL);
    }

    private static <E extends Enum> Collection<E> _parseDisplayNameParam(ExternalContext external, String paramName, Class<E> enumClass, E defaultValue) throws InvalidConfigException {
        try {
            return Enums.parseDisplayNameEnumRequestParameter((ExternalContext)external, (String)paramName, enumClass, defaultValue);
        }
        catch (EnumParseException e) {
            throw new InvalidConfigException(e.getMessage());
        }
    }

    public abstract Collection<Integer> getPlatformVariants();

    public abstract Collection<LocaleContext> getLocaleVariants();

    public abstract Collection<Integer> getReadingDirectionVariants();

    public abstract Collection<TrinidadAgent.Application> getAgentApplicationVariants();

    public abstract Collection<AccessibilityProfile> getAccessibilityVariants();

    public abstract Collection<ContainerType> getContainerTypes();

    public abstract Collection<RequestType> getRequestTypes();

    public abstract Collection<StyleClassType> getStyleClassTypes();

    public abstract String getTargetDirectoryPath();

    protected PregenConfig() {
    }

    private static final class NullPregenConfig
    extends PregenConfig {
        private NullPregenConfig() {
        }

        @Override
        public Collection<Integer> getPlatformVariants() {
            return Collections.emptySet();
        }

        @Override
        public Collection<LocaleContext> getLocaleVariants() {
            return Collections.emptySet();
        }

        @Override
        public Collection<Integer> getReadingDirectionVariants() {
            return Collections.emptySet();
        }

        @Override
        public Collection<TrinidadAgent.Application> getAgentApplicationVariants() {
            return Collections.emptySet();
        }

        @Override
        public Collection<AccessibilityProfile> getAccessibilityVariants() {
            return Collections.emptySet();
        }

        @Override
        public Collection<ContainerType> getContainerTypes() {
            return Collections.emptySet();
        }

        @Override
        public Collection<RequestType> getRequestTypes() {
            return Collections.emptySet();
        }

        @Override
        public Collection<StyleClassType> getStyleClassTypes() {
            return Collections.emptySet();
        }

        @Override
        public String getTargetDirectoryPath() {
            return null;
        }
    }

    private static class CommonPregenConfig
    extends ParamPregenConfig {
        public CommonPregenConfig(FacesContext context) {
            super(context);
        }

        @Override
        public Collection<Integer> getPlatformVariants() {
            return Arrays.asList(11, 8, 3, 2, 1);
        }

        @Override
        public Collection<LocaleContext> getLocaleVariants() {
            return Arrays.asList(NullLocaleContext.getLeftToRightContext(), NullLocaleContext.getRightToLeftContext());
        }

        @Override
        public Collection<Integer> getReadingDirectionVariants() {
            return Arrays.asList(1);
        }

        @Override
        public Collection<TrinidadAgent.Application> getAgentApplicationVariants() {
            return Arrays.asList(TrinidadAgent.Application.GECKO, TrinidadAgent.Application.IEXPLORER, TrinidadAgent.Application.SAFARI);
        }

        @Override
        public Collection<AccessibilityProfile> getAccessibilityVariants() {
            return Arrays.asList(AccessibilityProfile.getDefaultInstance());
        }
    }

    private static class AllPregenConfig
    extends ParamPregenConfig {
        public AllPregenConfig(FacesContext context) {
            super(context);
        }

        @Override
        public Collection<Integer> getPlatformVariants() {
            return ALL_VARIANTS;
        }

        @Override
        public Collection<LocaleContext> getLocaleVariants() {
            return ALL_VARIANTS;
        }

        @Override
        public Collection<Integer> getReadingDirectionVariants() {
            return ALL_VARIANTS;
        }

        @Override
        public Collection<TrinidadAgent.Application> getAgentApplicationVariants() {
            return ALL_VARIANTS;
        }

        @Override
        public Collection<AccessibilityProfile> getAccessibilityVariants() {
            return ALL_VARIANTS;
        }
    }

    private static abstract class ParamPregenConfig
    extends PregenConfig {
        private final Collection<ContainerType> _containerTypes;
        private final Collection<RequestType> _requestTypes;
        private final Collection<StyleClassType> _styleClassTypes;
        private final String _targetDirectoryPath;

        public ParamPregenConfig(FacesContext context) throws InvalidConfigException {
            ExternalContext external = context.getExternalContext();
            this._containerTypes = PregenConfig._parseDisplayNameParam(external, "containerType", ContainerType.class, ContainerType.SERVLET);
            this._requestTypes = PregenConfig._parseDisplayNameParam(external, "requestType", RequestType.class, RequestType.NONSECURE);
            this._styleClassTypes = PregenConfig._parseDisplayNameParam(external, "styleClassType", StyleClassType.class, StyleClassType.COMPRESSED);
            this._targetDirectoryPath = ParamPregenConfig._getTargetDirectoryPath(context);
        }

        @Override
        public Collection<ContainerType> getContainerTypes() {
            return this._containerTypes;
        }

        @Override
        public Collection<RequestType> getRequestTypes() {
            return this._requestTypes;
        }

        @Override
        public Collection<StyleClassType> getStyleClassTypes() {
            return this._styleClassTypes;
        }

        @Override
        public String getTargetDirectoryPath() {
            return this._targetDirectoryPath;
        }

        private static String _getTargetDirectoryPath(FacesContext context) throws InvalidConfigException {
            String targetDirectoryPath = ParamPregenConfig._getNormalizedTargetDirectoryPath(context);
            try {
                FileUtils.toWritableDirectory((String)targetDirectoryPath);
            }
            catch (IOException e) {
                throw new InvalidConfigException(e.getMessage());
            }
            return targetDirectoryPath;
        }

        private static String _getNormalizedTargetDirectoryPath(FacesContext context) {
            String targetDirectoryPath = System.getProperty(PregenConfig._TARGET_DIRECTORY_PROPERTY);
            if (targetDirectoryPath == null || targetDirectoryPath.isEmpty()) {
                targetDirectoryPath = CoreRenderingContext.getTemporaryDirectory(context, false);
            }
            return ParamPregenConfig._normalizeDirectoryPath(targetDirectoryPath);
        }

        private static String _normalizeDirectoryPath(String path) throws InvalidConfigException {
            if (path == null || path.isEmpty()) {
                String message = _LOG.getMessage("SKIN_PREGEN_NO_TARGET_DIRECTORY", (Object)PregenConfig._TARGET_DIRECTORY_PROPERTY);
                throw new InvalidConfigException(message);
            }
            return ParamPregenConfig._hasTrailingSeparator(path) ? path.substring(0, path.length() - 1) : path;
        }

        private static boolean _hasTrailingSeparator(String path) {
            char lastChar = path.charAt(path.length() - 1);
            return lastChar == File.separatorChar || lastChar == '/';
        }
    }

    public static enum StyleClassType {
        COMPRESSED("compressed"),
        UNCOMPRESSED("uncompressed");

        private final String _displayName;
        private static final Map<String, StyleClassType> _displayNameMap;

        private StyleClassType(String displayName) {
            this._displayName = displayName;
        }

        public String displayName() {
            return this._displayName;
        }

        public static StyleClassType valueOfDisplayName(String displayName) {
            return (StyleClassType)Enums.stringToEnum(_displayNameMap, (String)displayName, StyleClassType.class);
        }

        static {
            _displayNameMap = Enums.createDisplayNameMap(StyleClassType.class);
        }
    }

    public static enum RequestType {
        NONSECURE("nonsecure"),
        SECURE("secure");

        private final String _displayName;
        private static final Map<String, RequestType> _displayNameMap;

        private RequestType(String displayName) {
            this._displayName = displayName;
        }

        public String displayName() {
            return this._displayName;
        }

        public static RequestType valueOfDisplayName(String displayName) {
            return (RequestType)Enums.stringToEnum(_displayNameMap, (String)displayName, RequestType.class);
        }

        static {
            _displayNameMap = Enums.createDisplayNameMap(RequestType.class);
        }
    }

    public static enum ContainerType {
        SERVLET("servlet"),
        PORTLET("portlet");

        private final String _displayName;
        private static final Map<String, ContainerType> _displayNameMap;

        private ContainerType(String displayName) {
            this._displayName = displayName;
        }

        public String displayName() {
            return this._displayName;
        }

        public static ContainerType valueOfDisplayName(String displayName) {
            return (ContainerType)Enums.stringToEnum(_displayNameMap, (String)displayName, ContainerType.class);
        }

        static {
            _displayNameMap = Enums.createDisplayNameMap(ContainerType.class);
        }
    }

    public static enum Variants {
        COMMON("common"),
        ALL("all");

        private final String _displayName;
        private static final Map<String, Variants> _displayNameMap;

        private Variants(String displayName) {
            this._displayName = displayName;
        }

        public String displayName() {
            return this._displayName;
        }

        public static Variants valueOfDisplayName(String displayName) {
            return (Variants)Enums.stringToEnum(_displayNameMap, (String)displayName, Variants.class);
        }

        static {
            _displayNameMap = Enums.createDisplayNameMap(Variants.class);
        }
    }
}

