/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.pregen.variant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidadinternal.share.nls.LocaleContextImpl;
import org.apache.myfaces.trinidadinternal.share.nls.NullLocaleContext;
import org.apache.myfaces.trinidadinternal.skin.pregen.variant.SkinVariantExtractor;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetNode;

final class LocaleVariantExtractor
implements SkinVariantExtractor<LocaleContext> {
    private final Collection<Locale> _locales = new TreeSet<Locale>(_LOCALE_COMPARATOR);
    private static final Comparator<Locale> _LOCALE_COMPARATOR = new LocaleComparator();

    @Override
    public void visit(StyleSheetNode node) {
        Collection<Locale> nodeLocales = node.getLocales();
        for (Locale locale : nodeLocales) {
            this._locales.add(locale);
        }
    }

    @Override
    public List<LocaleContext> getVariants() {
        List<LocaleContext> localeContexts = LocaleVariantExtractor._toLocaleContexts(this._locales);
        return localeContexts;
    }

    private static List<LocaleContext> _toLocaleContexts(Collection<Locale> locales) {
        int size = locales.size() + 2;
        ArrayList<LocaleContext> localeContexts = new ArrayList<LocaleContext>(size);
        LocaleVariantExtractor._addNullLocaleContexts(localeContexts);
        LocaleVariantExtractor._addLocaleContexts(localeContexts, locales);
        return localeContexts;
    }

    private static void _addNullLocaleContexts(Collection<LocaleContext> localeContexts) {
        localeContexts.add(NullLocaleContext.getLeftToRightContext());
        localeContexts.add(NullLocaleContext.getRightToLeftContext());
    }

    private static void _addLocaleContexts(Collection<LocaleContext> localeContexts, Collection<Locale> locales) {
        for (Locale locale : locales) {
            localeContexts.add(new LocaleContextImpl(locale));
        }
    }

    private static final class LocaleComparator
    implements Comparator<Locale> {
        private LocaleComparator() {
        }

        @Override
        public int compare(Locale locale1, Locale locale2) {
            return locale1.toString().compareTo(locale2.toString());
        }
    }
}

