/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public abstract class ComponentReference<T extends UIComponent>
implements Serializable {
    private volatile transient List<Object> _componentPath;
    private static final String _FINISH_INITIALIZATION_LIST_KEY = ComponentReference.class.getName() + "#FINISH_INITIALIZATION";
    private static final long serialVersionUID = -6803949693688638969L;

    private ComponentReference(List<Object> componentPath) {
        this._componentPath = componentPath;
    }

    public static <T extends UIComponent> ComponentReference<T> newUIComponentReference(T component) {
        String compId = component.getId();
        if (compId != null && ComponentReference.getUIViewRoot(component) != null) {
            String scopedId = ComponentReference.calculateScopedId(component, compId);
            return new StableComponentReference(scopedId, compId, ComponentReference.calculateComponentPath(component));
        }
        DeferredComponentReference reference = new DeferredComponentReference(component, null);
        ComponentReference._addToEnsureInitializationList(reference);
        return reference;
    }

    public final T getComponent() {
        String scopedId = this.getScopedId();
        UIComponent foundComponent = null;
        UIViewRoot root = FacesContext.getCurrentInstance().getViewRoot();
        List<Object> componentPath = this._componentPath;
        if (componentPath != null) {
            foundComponent = this._walkPathToComponent(root, componentPath);
        }
        if (!(foundComponent != null && this.getComponentId().equals(foundComponent.getId()) || (foundComponent = root.findComponent(scopedId)) == null)) {
            this._componentPath = ComponentReference.calculateComponentPath(foundComponent);
        }
        return (T)foundComponent;
    }

    public abstract void ensureInitialization();

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ComponentReference) {
            return this.getScopedId().equals(((ComponentReference)o).getScopedId());
        }
        return false;
    }

    public final int hashCode() {
        return this.getScopedId().hashCode();
    }

    public final String toString() {
        return super.toString() + ":" + this.getScopedId();
    }

    protected abstract String getScopedId();

    protected abstract String getComponentId();

    protected final void setComponentPath(List<Object> componentPath) {
        this._componentPath = componentPath;
    }

    protected static List<Object> calculateComponentPath(UIComponent component) {
        ArrayList<Object> componentHierarchyList = new ArrayList<Object>();
        UIComponent currComponent = component;
        for (UIComponent currParent = currComponent.getParent(); currParent != null; currParent = currParent.getParent()) {
            int childIndex = currParent.getChildren().indexOf(currComponent);
            if (childIndex != -1) {
                componentHierarchyList.add(childIndex);
            } else {
                Set entries = currParent.getFacets().entrySet();
                for (Map.Entry entry : entries) {
                    if (!currComponent.equals(entry.getValue())) continue;
                    componentHierarchyList.add(entry.getKey());
                    break;
                }
            }
            currComponent = currParent;
        }
        if (!(currComponent instanceof UIViewRoot)) {
            throw new IllegalStateException("The component " + component + " is NOT connected to the component tree");
        }
        return componentHierarchyList;
    }

    protected static String calculateScopedId(UIComponent component, String componentId) {
        if (componentId == null) {
            throw new IllegalStateException("Can't create a ComponentReference for component " + component + " no id");
        }
        int scopedIdLength = componentId.length();
        ArrayList<String> scopedIdList = new ArrayList<String>();
        for (UIComponent currAncestor = component.getParent(); currAncestor != null; currAncestor = currAncestor.getParent()) {
            if (!(currAncestor instanceof NamingContainer)) continue;
            String currId = currAncestor.getId();
            scopedIdLength += currId.length() + 1;
            scopedIdList.add(currId);
        }
        return ComponentReference._createScopedId(scopedIdLength, scopedIdList, componentId);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this.getScopedId());
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static void _addToEnsureInitializationList(ComponentReference<?> reference) {
        Map requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
        ArrayList initializeList = (ArrayList)requestMap.get(_FINISH_INITIALIZATION_LIST_KEY);
        if (initializeList == null) {
            initializeList = new ArrayList();
            requestMap.put(_FINISH_INITIALIZATION_LIST_KEY, initializeList);
        }
        initializeList.add(reference);
    }

    private static String _createScopedId(int scopedIdLength, List<String> scopedIdList, String componentId) {
        StringBuilder builder = new StringBuilder(scopedIdLength);
        for (int i = scopedIdList.size() - 1; i >= 0; --i) {
            builder.append(scopedIdList.get(i));
            builder.append(':');
        }
        builder.append(componentId);
        return builder.toString();
    }

    protected static UIViewRoot getUIViewRoot(UIComponent component) {
        UIComponent currComponent = component;
        for (UIComponent currParent = currComponent.getParent(); currParent != null; currParent = currParent.getParent()) {
            currComponent = currParent;
        }
        return currComponent instanceof UIViewRoot ? (UIViewRoot)currComponent : null;
    }

    private UIComponent _walkPathToComponent(UIViewRoot root, List<Object> componentPath) {
        UIViewRoot currFound = root;
        for (int i = componentPath.size() - 1; i >= 0; --i) {
            Object location = componentPath.get(i);
            if (location instanceof Integer) {
                List children;
                int childIndex = (Integer)location;
                if (childIndex < (children = currFound.getChildren()).size()) {
                    currFound = (UIComponent)children.get(childIndex);
                    continue;
                }
                return null;
            }
            String facetName = location.toString();
            if ((currFound = (UIComponent)currFound.getFacets().get(facetName)) != null) continue;
            return null;
        }
        return currFound;
    }

    private static final class SerializationProxy
    implements Serializable {
        private final String _scopedId;
        private static final long serialVersionUID = 1L;

        SerializationProxy(String scopedId) {
            this._scopedId = scopedId;
        }

        private Object readResolve() {
            return new StableComponentReference(this._scopedId);
        }
    }

    private static final class DeferredComponentReference<T extends UIComponent>
    extends ComponentReference {
        private transient T _component;
        private volatile transient String _componentId;
        private volatile String _scopedId;
        private static final long serialVersionUID = 1L;

        private DeferredComponentReference(T component) {
            super(null);
            this._component = component;
        }

        @Override
        public void ensureInitialization() {
            this.getScopedId();
        }

        @Override
        protected String getScopedId() {
            String scopedId = this._scopedId;
            if (scopedId == null) {
                T component = this._component;
                if (component != null) {
                    String componentId = component.getId();
                    this._scopedId = scopedId = DeferredComponentReference.calculateScopedId(component, componentId);
                    this._componentId = componentId;
                    this.setComponentPath(DeferredComponentReference.calculateComponentPath(component));
                    this._component = null;
                } else {
                    scopedId = this._scopedId;
                }
            }
            return scopedId;
        }

        @Override
        protected String getComponentId() {
            return this._componentId;
        }

        /* synthetic */ DeferredComponentReference(UIComponent x0, 1 x1) {
            this(x0);
        }
    }

    private static final class StableComponentReference
    extends ComponentReference {
        private final String _componentId;
        private final String _scopedId;
        private static final long serialVersionUID = 1L;

        private StableComponentReference(String scopedId) {
            this(scopedId, scopedId.substring(scopedId.lastIndexOf(58) + 1), null);
        }

        private StableComponentReference(String scopedId, String componentId, List<Object> componentPath) {
            super(componentPath);
            if (scopedId == null) {
                throw new NullPointerException();
            }
            this._scopedId = scopedId;
            this._componentId = componentId;
        }

        @Override
        public void ensureInitialization() {
        }

        @Override
        protected String getScopedId() {
            return this._scopedId;
        }

        @Override
        protected String getComponentId() {
            return this._componentId;
        }
    }
}

