/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

class PathHelper {
    private String _rowKey = null;
    private List<PathElement> _path = Collections.emptyList();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(PathHelper.class);

    protected PathHelper() {
    }

    public final void setRowKey(String rowKey) {
        this._rowKey = rowKey;
    }

    public final String getRowKey() {
        return this._rowKey;
    }

    public final int getPathSize() {
        return this._path.size();
    }

    public final List<String> getPath() {
        int sz = this._path.size();
        ArrayList<String> path = new ArrayList<String>(sz + 1);
        if (sz > 0) {
            for (int i = 0; i < sz; ++i) {
                path.add(this.getPath(i));
            }
        }
        path.add(this.getRowKey());
        return path;
    }

    public final String getPath(int index) {
        return this._getPathElement((int)index).rowKey;
    }

    public final void setPath(List<String> path) {
        int sz;
        int n = sz = path == null ? 0 : path.size();
        if (sz > 0) {
            this._path = new ArrayList<PathElement>(sz);
            int lastIndex = sz - 1;
            for (int i = 0; i < lastIndex; ++i) {
                this.setRowKey(path.get(i));
                this.pushPath();
            }
            this.setRowKey(path.get(lastIndex));
        } else {
            this._path = Collections.emptyList();
            this.setRowKey(null);
        }
    }

    protected final Object getPathData(int index) {
        return this._getPathElement((int)index).node;
    }

    protected Object getLastPathData() {
        int sz = this.getPathSize();
        return sz > 0 ? this.getPathData(sz - 1) : null;
    }

    public final void pushPath() {
        if (this._rowKey == null) {
            throw new IllegalStateException(_LOG.getMessage("NULL_ROWKEY"));
        }
        Object parentData = this.getLastPathData();
        Object data = this.pushPath(parentData, this._rowKey);
        List comparant = Collections.emptyList();
        if (this._path == comparant) {
            this._path = new ArrayList<PathElement>(5);
        }
        this._path.add(new PathElement(this._rowKey, data));
        this._rowKey = null;
    }

    protected Object pushPath(Object parentData, String rowKey) {
        return null;
    }

    public final void popPath() {
        int sz = this._path.size();
        if (sz <= 0) {
            throw new IllegalStateException(_LOG.getMessage("NO_PATH_ELEMENT_TO_POP"));
        }
        PathElement lastPath = this._path.remove(sz - 1);
        this._rowKey = lastPath.rowKey;
    }

    private PathElement _getPathElement(int index) {
        return this._path.get(index);
    }

    private static final class PathElement {
        public final Object node;
        public final String rowKey;

        public PathElement(String rowKey, Object data) {
            this.rowKey = rowKey;
            this.node = data;
        }
    }
}

