/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.model;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.VariableMapper;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelListener;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.ModelUtils;
import org.apache.myfaces.trinidad.model.SortCriterion;
import org.apache.myfaces.trinidad.model.SortStrength;

public class SortableModel
extends CollectionModel {
    private SortCriterion _sortCriterion = null;
    private DataModel _model = null;
    private Object _wrappedData = null;
    private Map<String, Comparator> _propertyComparators;
    private IntList _sortedIndicesList = null;
    private IntList _baseIndicesList = null;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SortableModel.class);

    public SortableModel(Object model) {
        this.setWrappedData(model);
    }

    public SortableModel() {
    }

    @Override
    public Object getRowData() {
        return this._model.getRowData();
    }

    public Object getWrappedData() {
        return this._wrappedData;
    }

    @Override
    public boolean isRowAvailable() {
        return this._model.isRowAvailable();
    }

    public void setWrappedData(Object data) {
        this._baseIndicesList = null;
        this._model = ModelUtils.toDataModel(data);
        this._sortCriterion = null;
        this._sortedIndicesList = null;
        this._wrappedData = data;
    }

    @Override
    public int getRowCount() {
        return this._model.getRowCount();
    }

    @Override
    public void setRowIndex(int rowIndex) {
        int baseIndex = this._toBaseIndex(rowIndex);
        this._model.setRowIndex(baseIndex);
    }

    @Override
    public int getRowIndex() {
        int baseIndex = this._model.getRowIndex();
        return this._toSortedIndex(baseIndex);
    }

    @Override
    public Object getRowKey() {
        return this.isRowAvailable() ? Integer.valueOf(this._model.getRowIndex()) : null;
    }

    @Override
    public void setRowKey(Object key) {
        this._model.setRowIndex(this._toRowIndex(key));
    }

    public void addDataModelListener(DataModelListener listener) {
        this._model.addDataModelListener(listener);
    }

    public DataModelListener[] getDataModelListeners() {
        return this._model.getDataModelListeners();
    }

    public void removeDataModelListener(DataModelListener listener) {
        this._model.removeDataModelListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSortable(String property) {
        int oldIndex = this._model.getRowIndex();
        try {
            this._model.setRowIndex(0);
            if (!this._model.isRowAvailable()) {
                boolean bl = false;
                return bl;
            }
            Object data = this._model.getRowData();
            try {
                FacesContext context = FacesContext.getCurrentInstance();
                ELResolver resolver = SortableModel._getELResolver(context);
                ELContext elContext = SortableModel._getELContext(context, resolver);
                Object propertyValue = this.evaluateProperty(resolver, elContext, data, property);
                boolean bl = propertyValue instanceof Comparable || propertyValue == null;
                return bl;
            }
            catch (RuntimeException e) {
                _LOG.warning(e);
                boolean bl = false;
                this._model.setRowIndex(oldIndex);
                return bl;
            }
        }
        finally {
            this._model.setRowIndex(oldIndex);
        }
    }

    private Object evaluateProperty(ELResolver resolver, ELContext context, Object base, String property) {
        if (!property.contains(".")) {
            return resolver.getValue(context, base, (Object)property);
        }
        int index = property.indexOf(46);
        Object newBase = resolver.getValue(context, base, (Object)property.substring(0, index));
        return this.evaluateProperty(resolver, context, newBase, property.substring(index + 1));
    }

    @Override
    public List<SortCriterion> getSortCriteria() {
        if (this._sortCriterion == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this._sortCriterion);
    }

    @Override
    public void setSortCriteria(List<SortCriterion> criteria) {
        if (criteria == null || criteria.isEmpty()) {
            this._sortCriterion = null;
            this._sortedIndicesList = null;
            this._baseIndicesList = null;
        } else {
            SortCriterion sc = criteria.get(0);
            if (this._sortCriterion == null || !this._sortCriterion.equals(sc)) {
                this._sortCriterion = sc;
                this._sort(this._sortCriterion);
            }
        }
    }

    public Comparator getComparator(String propertyName) {
        return this._propertyComparators == null ? null : this._propertyComparators.get(propertyName);
    }

    public void setComparator(String propertyName, Comparator comparator) {
        assert (propertyName != null) : "Property name may not be null";
        if (comparator == null && this._propertyComparators != null) {
            this._propertyComparators.remove(propertyName);
            if (this._propertyComparators.isEmpty()) {
                this._propertyComparators = null;
            }
        } else if (comparator != null) {
            if (this._propertyComparators == null) {
                this._propertyComparators = new HashMap<String, Comparator>();
            }
            this._propertyComparators.put(propertyName, comparator);
        }
        if (this._sortCriterion != null && propertyName.equals(this._sortCriterion.getProperty())) {
            this._sort(this._sortCriterion);
        }
    }

    public void setCollator(String propertyName, Strength collatorStrength, Decomposition collatorDecomposition) {
        Collator collator;
        FacesContext facesContext;
        Locale locale = null;
        RequestContext reqCtx = RequestContext.getCurrentInstance();
        if (reqCtx != null && (facesContext = FacesContext.getCurrentInstance()) != null) {
            locale = SortableModel._getLocale(reqCtx, facesContext);
        }
        Collator collator2 = collator = locale == null ? Collator.getInstance() : Collator.getInstance(locale);
        if (collatorDecomposition != null) {
            collator.setDecomposition(collatorDecomposition.getIntValue());
        }
        if (collatorStrength != null) {
            collator.setStrength(collatorStrength.getIntValue());
        }
        this.setComparator(propertyName, collator);
    }

    public String toString() {
        return "SortableModel[" + this._model + "]";
    }

    private void _sort(SortCriterion sortCriterion) {
        int sz = this.getRowCount();
        if (this._baseIndicesList == null || this._baseIndicesList.size() != sz) {
            this._baseIndicesList = new IntList(sz);
        }
        int rowIndex = this._model.getRowIndex();
        this._model.setRowIndex(0);
        if (this._model.isRowAvailable()) {
            FacesContext context = FacesContext.getCurrentInstance();
            RequestContext rc = RequestContext.getCurrentInstance();
            ELResolver resolver = SortableModel._getELResolver(context);
            ELContext elContext = SortableModel._getELContext(context, resolver);
            Locale locale = SortableModel._getLocale(rc, context);
            Comparator<Integer> comp = new Comp(resolver, elContext, locale, sortCriterion.getProperty(), sortCriterion.getSortStrength());
            if (!sortCriterion.isAscending()) {
                comp = new Inverter<Integer>(comp);
            }
            Collections.sort(this._baseIndicesList, comp);
            this._sortedIndicesList = null;
        }
        this._model.setRowIndex(rowIndex);
    }

    private int _toSortedIndex(int baseIndex) {
        if (this._sortedIndicesList == null && this._baseIndicesList != null) {
            this._sortedIndicesList = (IntList)this._baseIndicesList.clone();
            for (int i = 0; i < this._baseIndicesList.size(); ++i) {
                Integer base = (Integer)this._baseIndicesList.get(i);
                this._sortedIndicesList.set(base, i);
            }
        }
        return this._convertIndex(baseIndex, this._sortedIndicesList);
    }

    private int _toBaseIndex(int sortedIndex) {
        return this._convertIndex(sortedIndex, this._baseIndicesList);
    }

    private int _convertIndex(int index, List<Integer> indices) {
        if (index < 0) {
            return index;
        }
        if (indices != null && indices.size() > index) {
            index = indices.get(index);
        }
        return index;
    }

    private int _toRowIndex(Object rowKey) {
        if (rowKey == null) {
            return -1;
        }
        try {
            return (Integer)rowKey;
        }
        catch (ClassCastException e) {
            _LOG.warning("INVALID_ROWKEY", new Object[]{rowKey, rowKey.getClass()});
            _LOG.warning(e);
            return -1;
        }
    }

    static Object __resolveProperty(Object object, String propertyName) {
        FacesContext context = FacesContext.getCurrentInstance();
        ELResolver resolver = SortableModel._getELResolver(context);
        ELContext elContext = SortableModel._getELContext(context, resolver);
        return resolver.getValue(elContext, object, (Object)propertyName);
    }

    private static ELContext _getELContext(FacesContext context, ELResolver resolver) {
        if (context != null) {
            return context.getELContext();
        }
        return new ELContextImpl(resolver);
    }

    private static ELResolver _getELResolver(FacesContext context) {
        if (context != null) {
            return context.getApplication().getELResolver();
        }
        ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        return factory.getApplication().getELResolver();
    }

    private static Locale _getLocale(RequestContext requestContext, FacesContext facesContext) {
        if (requestContext != null) {
            return requestContext.getFormattingLocale();
        }
        if (facesContext != null) {
            return facesContext.getViewRoot().getLocale();
        }
        return null;
    }

    private static final class ELContextImpl
    extends ELContext {
        private final ELResolver _resolver;

        public ELContextImpl(ELResolver resolver) {
            this._resolver = resolver;
        }

        public ELResolver getELResolver() {
            return this._resolver;
        }

        public FunctionMapper getFunctionMapper() {
            return null;
        }

        public VariableMapper getVariableMapper() {
            return null;
        }
    }

    private static final class Inverter<T>
    implements Comparator<T> {
        private final Comparator<T> _comp;

        public Inverter(Comparator<T> comp) {
            this._comp = comp;
        }

        @Override
        public int compare(T o1, T o2) {
            return this._comp.compare(o2, o1);
        }
    }

    private final class Comp
    implements Comparator<Integer> {
        private final ELResolver _resolver;
        private final ELContext _context;
        private final Collator _collator;
        private final String _prop;

        public Comp(ELResolver resolver, ELContext context, Locale locale, String property, SortStrength sortStrength) {
            this._resolver = resolver;
            this._context = context;
            if (locale != null || sortStrength != null) {
                this._collator = locale != null ? Collator.getInstance(locale) : Collator.getInstance();
                if (sortStrength != null) {
                    this._collator.setStrength(sortStrength.getStrength());
                }
            } else {
                this._collator = null;
            }
            this._prop = property;
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            int index1 = o1;
            int index2 = o2;
            SortableModel.this._model.setRowIndex(index1);
            Object instance1 = SortableModel.this._model.getRowData();
            Object value1 = SortableModel.this.evaluateProperty(this._resolver, this._context, instance1, this._prop);
            SortableModel.this._model.setRowIndex(index2);
            Object instance2 = SortableModel.this._model.getRowData();
            Object value2 = SortableModel.this.evaluateProperty(this._resolver, this._context, instance2, this._prop);
            if (value1 == null) {
                return value2 == null ? 0 : -1;
            }
            if (value2 == null) {
                return 1;
            }
            Comparator comparator = SortableModel.this.getComparator(this._prop);
            if (comparator == null) {
                if (value1 instanceof Comparable) {
                    if (value1 instanceof String && value2 instanceof String) {
                        return this._compare((String)value1, (String)value2);
                    }
                    return ((Comparable)value1).compareTo(value2);
                }
                return this._compare(value1.toString(), value2.toString());
            }
            return comparator.compare(value1, value2);
        }

        private int _compare(String s1, String s2) {
            if (this._collator != null) {
                return this._collator.compare(s1, s2);
            }
            return s1.compareTo(s2);
        }
    }

    private static final class IntList
    extends ArrayList<Integer> {
        private static final long serialVersionUID = 1L;

        public IntList(int size) {
            super(size);
            this._expandToSize(size);
        }

        private void _expandToSize(int desiredSize) {
            for (int i = 0; i < desiredSize; ++i) {
                this.add(i);
            }
        }
    }

    public static enum Decomposition {
        NO_DECOMPOSITION(0),
        CANONICAL_DECOMPOSITION(1),
        FULL_DECOMPOSITION(2);

        private final int _decomposition;

        private Decomposition(int decomposition) {
            this._decomposition = decomposition;
        }

        public int getIntValue() {
            return this._decomposition;
        }
    }

    public static enum Strength {
        IDENTICAL(3),
        PRIMARY(0),
        SECONDARY(1),
        TERTIARY(2);

        private final int _strength;

        private Strength(int strength) {
            this._strength = strength;
        }

        public int getIntValue() {
            return this._strength;
        }
    }
}

