/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

public final class ToStringHelper {
    private final StringBuilder _builder = new StringBuilder();
    private static final StringStyle _STYLE = new JSONStringStyle();
    private static final String _SPACE = " ";

    public ToStringHelper() {
        this(null);
    }

    public ToStringHelper(Object object) {
        if (object != null) {
            this._builder.append(object.getClass().getName());
            this._builder.append("@");
            this._builder.append(System.identityHashCode(object));
        }
    }

    public ToStringHelper append(String fieldName, Object value) {
        if (fieldName != null) {
            String stringValue = null;
            if (value != null) {
                stringValue = value.toString();
            }
            this._append(fieldName, stringValue);
        }
        return this;
    }

    private ToStringHelper _append(String fieldName, String value) {
        if (value == null) {
            if (_STYLE.isNullFieldAppended()) {
                value = _STYLE.getNullText();
            } else {
                return this;
            }
        }
        this._appendNonNullNameValuePair(fieldName, value);
        return this;
    }

    private void _appendNonNullNameValuePair(String fieldName, String value) {
        if (fieldName != null && value != null) {
            StringBuilder pair = new StringBuilder();
            int contentEndIndex = this._builder.lastIndexOf(_STYLE.getContentEnd());
            if (contentEndIndex == -1) {
                this._builder.append(_SPACE);
                this._builder.append(_STYLE.getContentStart());
                this._builder.append(_STYLE.getContentEnd());
                contentEndIndex = this._builder.length() - 1;
            } else {
                pair.append(_STYLE.getFieldSeparator());
                pair.append(_SPACE);
            }
            pair.append(fieldName);
            pair.append(_STYLE.getFieldNameValueSeparator());
            pair.append(_SPACE);
            pair.append(value);
            this._builder.insert(contentEndIndex, pair);
        }
    }

    public String toString() {
        return this._builder.toString();
    }

    private static class JSONStringStyle
    implements StringStyle {
        private static String _CONTENT_START = "{";
        private static String _CONTENT_END = "}";
        private static String _FIELD_SEPARATOR = ",";
        private static String _FIELD_NAME_VALUE_SEPARATOR = ":";
        private static String _NULL_TEXT = "'null'";

        private JSONStringStyle() {
        }

        @Override
        public String getContentStart() {
            return _CONTENT_START;
        }

        @Override
        public String getContentEnd() {
            return _CONTENT_END;
        }

        @Override
        public String getFieldSeparator() {
            return _FIELD_SEPARATOR;
        }

        @Override
        public String getFieldNameValueSeparator() {
            return _FIELD_NAME_VALUE_SEPARATOR;
        }

        @Override
        public boolean isNullFieldAppended() {
            return false;
        }

        @Override
        public String getNullText() {
            return _NULL_TEXT;
        }
    }

    private static interface StringStyle {
        public String getContentStart();

        public String getContentEnd();

        public String getFieldSeparator();

        public String getFieldNameValueSeparator();

        public boolean isNullFieldAppended();

        public String getNullText();
    }
}

