/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config.upload;

import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.UploadedFile;
import org.apache.myfaces.trinidadinternal.config.upload.UploadedFiles;

public class FileUploadUtils {
    private static final String _PROCESSED_PARAM = FileUploadUtils.class.getName() + ".PROCESSED";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(FileUploadUtils.class);
    private static final String[] _COPIED_ATTRIBUTES = new String[]{"org.apache.myfaces.trinidad.UPLOAD_MAX_MEMORY", "org.apache.myfaces.trinidad.UPLOAD_MAX_DISK_SPACE", "org.apache.myfaces.trinidad.UPLOAD_TEMP_DIR", "org.apache.myfaces.trinidad.UPLOAD_MAX_FILE_SIZE", "org.apache.myfaces.trinidad.UPLOAD_MAX_CHUNK_SIZE"};

    private FileUploadUtils() {
    }

    public static void setupRequest(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        if (null != session) {
            for (String attribute : _COPIED_ATTRIBUTES) {
                req.setAttribute(attribute, session.getAttribute(attribute));
            }
        }
    }

    public static void setupRequest(ExternalContext ec) {
        if (null != ec.getSession(false)) {
            Map sessionMap = ec.getSessionMap();
            Map requestMap = ec.getRequestMap();
            for (String attribute : _COPIED_ATTRIBUTES) {
                requestMap.put(attribute, sessionMap.get(attribute));
            }
        }
    }

    public static void markProcessed(HttpServletRequest req) {
        req.setAttribute(_PROCESSED_PARAM, (Object)Boolean.TRUE);
    }

    public static void markProcessed(ExternalContext ec) {
        ec.getRequestMap().put(_PROCESSED_PARAM, Boolean.TRUE);
    }

    public static boolean isProcessed(HttpServletRequest req) {
        return Boolean.TRUE.equals(req.getAttribute(_PROCESSED_PARAM));
    }

    public static boolean isProcessed(ExternalContext ec) {
        return Boolean.TRUE.equals(ec.getRequestMap().get(_PROCESSED_PARAM));
    }

    public static void addFile(HttpServletRequest req, String id, UploadedFile file) {
        if (null != file) {
            UploadedFiles files = UploadedFiles.getUploadedFiles(req);
            if (null == files) {
                files = new UploadedFiles(req);
            }
            FileUploadUtils.__addFile(files, id, file);
        }
    }

    static void __addFile(UploadedFiles files, String id, UploadedFile file) {
        if (file != null) {
            files.__put(id, file);
            if (_LOG.isFine()) {
                _LOG.fine("Uploaded file " + file.getFilename() + "(" + file.getLength() + " bytes) for ID " + id);
            }
        }
    }
}

