/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRendererUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AccessKeyUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AutoSubmitUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.FormInputRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.HiddenLabelUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.LabelAndMessageRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlConstants;

public abstract class SimpleSelectBooleanRenderer
extends FormInputRenderer {
    private PropertyKey _textKey;
    private PropertyKey _accessKeyKey;

    public SimpleSelectBooleanRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._textKey = type.findKey("text");
        this._accessKeyKey = type.findKey("accessKey");
    }

    protected abstract Object getValueAttr(RenderingContext var1);

    protected abstract Object getType();

    protected abstract String getIconName(boolean var1, boolean var2);

    protected abstract String getIconAltTextName(boolean var1);

    protected void renderNameAttribute(FacesContext context, RenderingContext rc, FacesBean bean) throws IOException {
    }

    @Override
    protected void encodeAllAsElement(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = LabelAndMessageRenderer.__getCachedClientId(rc);
        boolean getRenderSimpleSpan = this.getRenderSimpleSpan(component, bean);
        if (getRenderSimpleSpan) {
            writer.startElement("span", component);
            this.renderRootDomElementStyles(context, rc, component, bean);
            this._renderPartialId(context, rc, clientId);
        }
        writer.startElement("span", component);
        if (SimpleSelectBooleanRenderer.supportsScripting(rc)) {
            this.renderSpanEventHandlers(context, component, bean);
        }
        SimpleSelectBooleanRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)this.getContentStyleClass(component, bean));
        SimpleSelectBooleanRenderer.renderInlineStyleAttribute(context, rc, component, this.getContentStyle(component, bean));
        if (!getRenderSimpleSpan) {
            this._renderPartialId(context, rc, clientId);
        }
        char accessKey = SimpleSelectBooleanRenderer.supportsAccessKeys(rc) ? (char)this.getAccessKey(component, bean) : (char)'\uffff';
        if (this.isAutoSubmit(component, bean)) {
            AutoSubmitUtils.writeDependencies(context, rc);
        }
        writer.startElement("input", null);
        this.renderId(context, component);
        this.renderShortDescAttribute(context, rc, component, bean);
        if (SimpleSelectBooleanRenderer.supportsScripting(rc)) {
            this.renderInputEventHandlers(context, component, bean);
        }
        this.renderDisabledAttribute(context, rc, component, bean);
        if (!this.shouldRenderName(context, component)) {
            this.renderNameAttribute(context, rc, bean);
        }
        if (accessKey != '\uffff') {
            writer.writeAttribute("accesskey", (Object)Character.toString(accessKey), null);
        }
        writer.writeAttribute("type", this.getType(), null);
        writer.writeAttribute("value", this.getValueAttr(rc), null);
        Object value = this.getSubmittedValue(component, bean);
        if (value == null) {
            value = this.getValue(component, bean);
        }
        if (!(value instanceof Boolean)) {
            value = Boolean.valueOf(this.getConvertedString(context, component, bean));
        }
        if (Boolean.TRUE.equals(value)) {
            writer.writeAttribute("checked", (Object)Boolean.TRUE, "value");
        }
        writer.endElement("input");
        String text = this.getText(component, bean);
        boolean renderLabelTags = this._isLabelTagRendered(rc, text, accessKey);
        if (renderLabelTags) {
            writer.startElement("label", null);
            writer.writeAttribute("for", (Object)clientId, null);
            HiddenLabelUtils.rememberLabel(rc, clientId);
        }
        this.renderText(context, rc, component, bean, true, false, text, accessKey);
        if (renderLabelTags) {
            writer.endElement("label");
        }
        if (this.isHiddenLabelRequired(rc)) {
            this.renderShortDescAsHiddenLabel(context, rc, component, bean);
        }
        writer.endElement("span");
        if (getRenderSimpleSpan) {
            writer.endElement("span");
        }
    }

    @Override
    protected void encodeAllAsNonElement(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean getRenderSimpleSpan = this.getRenderSimpleSpan(component, bean);
        String clientId = LabelAndMessageRenderer.__getCachedClientId(rc);
        if (getRenderSimpleSpan) {
            writer.startElement("span", component);
            this.renderRootDomElementStyles(context, rc, component, bean);
            this._renderPartialId(context, rc, clientId);
        }
        writer.startElement("div", component);
        if (!getRenderSimpleSpan) {
            this._renderPartialId(context, rc, clientId);
        }
        SimpleSelectBooleanRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)this.getContentStyleClass(component, bean));
        SimpleSelectBooleanRenderer.renderInlineStyleAttribute(context, rc, component, this.getContentStyle(component, bean));
        this.renderShortDescAttribute(context, rc, component, bean);
        Object value = this.getSubmittedValue(component, bean);
        if (value == null) {
            value = this.getValue(component, bean);
        }
        if (!(value instanceof Boolean)) {
            value = Boolean.valueOf(this.getConvertedString(context, component, bean));
        }
        boolean selected = Boolean.TRUE.equals(value);
        boolean disabled = this.getDisabled(component, bean);
        String iconName = this.getIconName(selected, disabled);
        Icon icon = rc.getIcon(iconName);
        String altTextName = this.getIconAltTextName(selected);
        String shortDesc = rc.getTranslatedString(altTextName);
        OutputUtils.renderIcon(context, rc, icon, shortDesc, null);
        String text = this.getText(component, bean);
        if (text != null) {
            writer.writeText((Object)XhtmlConstants.NBSP_STRING, null);
            writer.writeText((Object)text, "text");
        }
        writer.endElement("div");
        if (getRenderSimpleSpan) {
            writer.endElement("span");
        }
    }

    protected void renderSpanEventHandlers(FacesContext context, UIComponent component, FacesBean bean) throws IOException {
    }

    protected void renderInputEventHandlers(FacesContext context, UIComponent component, FacesBean bean) throws IOException {
        this.renderEventHandlers(context, component, bean);
    }

    protected void renderAccessKeyAttribute(FacesContext context, RenderingContext rc, FacesBean bean) throws IOException {
    }

    protected void renderText(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, boolean renderAccessKeys, boolean renderID, String text, char accessKey) throws IOException {
        if (text != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("span", component);
            if (renderID) {
                this.renderId(context, component);
            }
            if (renderAccessKeys && SimpleSelectBooleanRenderer.supportsAccessKeys(rc)) {
                AccessKeyUtils.renderAccessKeyText(context, (Object)text, accessKey, "AFAccessKeyStyle");
            } else {
                writer.writeText((Object)text, null);
            }
            writer.endElement("span");
        }
    }

    protected String getAutoSubmitScript(UIComponent component, FacesBean bean) {
        RenderingContext arc = RenderingContext.getCurrentInstance();
        String source = LabelAndMessageRenderer.__getCachedClientId(arc);
        boolean immediate = this.isImmediate(component, bean);
        boolean isRadio = this.isRadio();
        return AutoSubmitUtils.getSubmitScript(arc, source, immediate, isRadio, "autosub", null, true);
    }

    protected boolean isRadio() {
        return false;
    }

    protected String getCompositeId(String clientId) {
        return clientId + "__xc_" + "c";
    }

    protected String getText(UIComponent component, FacesBean bean) {
        return SimpleSelectBooleanRenderer.toString((Object)bean.getProperty(this._textKey));
    }

    protected char getAccessKey(UIComponent component, FacesBean bean) {
        return SimpleSelectBooleanRenderer.toChar((Object)bean.getProperty(this._accessKeyKey));
    }

    protected boolean getRenderSimpleSpan(UIComponent component, FacesBean bean) {
        return this.getSimple(component, bean);
    }

    private boolean _isLabelTagRendered(RenderingContext rc, String text, char accessKey) {
        if (text == null) {
            return false;
        }
        return !SimpleSelectBooleanRenderer.isInaccessibleMode((RenderingContext)rc) || accessKey != '\uffff';
    }

    private void _renderPartialId(FacesContext context, RenderingContext rc, String clientId) throws IOException {
        if (clientId != null && CoreRendererUtils.supportsPartialRendering(rc)) {
            String compositeId = this.getCompositeId(clientId);
            context.getResponseWriter().writeAttribute("id", (Object)compositeId, null);
        }
    }
}

