/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.LibraryScriptlet;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.Scriptlet;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.LocaleList;

public class LocaleInfoScriptlet
extends LibraryScriptlet {
    public static final String LOCALE_INFO_KEY = "LocaleInfo";
    private static final String _RESOURCE_BASE = "resources/LocaleElements_";
    private static final Scriptlet _sInstance = new LocaleInfoScriptlet();

    public static Scriptlet sharedInstance() {
        return _sInstance;
    }

    public LocaleInfoScriptlet() {
        super(LOCALE_INFO_KEY, null, new Object[]{"Locale"});
    }

    @Override
    protected void outputScriptletImpl(FacesContext context, RenderingContext arc) throws IOException {
        char decimalSeparator;
        ResponseWriter writer = context.getResponseWriter();
        LocaleContext lc = arc.getLocaleContext();
        writer.startElement("script", null);
        XhtmlRenderer.renderScriptDeferAttribute(context, arc);
        XhtmlRenderer.renderScriptTypeAttribute(context, arc);
        writer.writeText((Object)"var _locale='", null);
        writer.writeText((Object)lc.getFormattingIANALocaleString(), null);
        writer.writeText((Object)"';", null);
        writer.writeText((Object)"var _tLocale='", null);
        writer.writeText((Object)lc.getTranslationIANALocaleString(), null);
        writer.writeText((Object)"';", null);
        char groupingSeparator = lc.getGroupingSeparator();
        if (groupingSeparator != '\u0000') {
            writer.writeText((Object)"var _groupingSep='", null);
            writer.writeText((Object)XhtmlUtils.escapeJS(String.valueOf(groupingSeparator)), null);
            writer.writeText((Object)"';", null);
        }
        if ((decimalSeparator = lc.getDecimalSeparator()) != '\u0000') {
            writer.writeText((Object)"var _decimalSep='", null);
            writer.writeText((Object)XhtmlUtils.escapeJS(String.valueOf(decimalSeparator)), null);
            writer.writeText((Object)"';", null);
        }
        writer.endElement("script");
        super.outputScriptletImpl(context, arc);
    }

    @Override
    protected String getLibraryName(FacesContext context, RenderingContext arc) {
        Locale elementsLocale = LocaleInfoScriptlet._getJSLocaleElementsLocale(this.getFormattingLocale(arc));
        String var = this.getSupportedLocaleVariant(arc);
        if (var != null) {
            elementsLocale = new Locale(elementsLocale.getLanguage(), elementsLocale.getCountry(), var);
        }
        String locStr = elementsLocale.toString();
        StringBuffer buffer = new StringBuffer(_RESOURCE_BASE.length() + (var == null ? 0 : var.length() + 1) + locStr.length());
        buffer.append(_RESOURCE_BASE);
        buffer.append(locStr);
        return buffer.toString();
    }

    @Override
    protected String getExtraParameters(FacesContext context, RenderingContext arc) {
        String locStr = arc.getLocaleContext().getTranslationLocale().toString();
        String extraParams = "?loc=" + locStr;
        return extraParams;
    }

    protected Locale getFormattingLocale(RenderingContext rc) {
        return rc.getLocaleContext().getFormattingLocale();
    }

    public String getSupportedLocaleVariant(RenderingContext arc) {
        LocaleContext lc = arc.getLocaleContext();
        Locale l = lc.getFormattingLocale();
        String variant = l.getVariant();
        if ((variant = variant.toUpperCase()).startsWith("ORACLE")) {
            return variant;
        }
        return null;
    }

    private static Locale _getJSLocaleElementsLocale(Locale inLocale) {
        Locale outLocale;
        HashMap<Locale, Locale> supportedMap = LocaleList.getSupportedLocales();
        if (supportedMap.containsKey(outLocale = inLocale)) {
            return outLocale;
        }
        String variant = outLocale.getVariant();
        String language = outLocale.getLanguage();
        boolean isSupportedLocale = false;
        if (variant.length() != 0) {
            outLocale = new Locale(language, outLocale.getCountry());
            isSupportedLocale = supportedMap.containsKey(outLocale);
        }
        if (!isSupportedLocale && !supportedMap.containsKey(outLocale = new Locale(language, ""))) {
            outLocale = Locale.getDefault();
        }
        return outLocale;
    }
}

