/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.SpecialColumnRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableSelectManyRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableSelectOneRenderer;

public class SelectionColumnRenderer
extends SpecialColumnRenderer {
    private final CoreRenderer _singleRenderer;
    private final CoreRenderer _multiRenderer;

    public SelectionColumnRenderer(FacesBean.Type tableType) {
        this._singleRenderer = new TableSelectOneRenderer(tableType);
        this._multiRenderer = new TableSelectManyRenderer(tableType);
    }

    @Override
    protected void renderKids(FacesContext context, RenderingContext rc, TableRenderingContext trc, UIComponent column) throws IOException {
        UIComponent table = trc.getTable();
        this.delegateRenderer(context, rc, table, this.getFacesBean(table), trc.hasSelectAll() ? this._multiRenderer : this._singleRenderer);
    }

    @Override
    protected String getHeaderText(UIComponent component, FacesBean bean) {
        RenderingContext arc = RenderingContext.getCurrentInstance();
        TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
        String key = SelectionColumnRenderer._isMultipleSelection(tContext) ? "af_tableSelectMany.SELECT_COLUMN_HEADER" : "af_tableSelectOne.SELECT_COLUMN_HEADER";
        return arc.getTranslatedString(key);
    }

    @Override
    protected boolean getNoWrap(UIComponent component, FacesBean bean) {
        return false;
    }

    @Override
    protected String getFormatType(UIComponent component, FacesBean bean) {
        return "center";
    }

    @Override
    protected String getHeaderStyleClass(TableRenderingContext tContext) {
        return "af|column::header-icon-format";
    }

    private static boolean _isMultipleSelection(TableRenderingContext tContext) {
        return tContext.hasSelectAll();
    }
}

