/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.pregen;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.skin.DocumentProviderSkin;
import org.apache.myfaces.trinidadinternal.skin.pregen.SkinPregenerator;
import org.apache.myfaces.trinidadinternal.skin.pregen.config.PregenConfig;
import org.apache.myfaces.trinidadinternal.skin.pregen.context.PregenStyleContext;
import org.apache.myfaces.trinidadinternal.skin.pregen.variant.SkinVariant;
import org.apache.myfaces.trinidadinternal.skin.pregen.variant.SkinVariants;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.StyleProvider;
import org.apache.myfaces.trinidadinternal.style.util.NameUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetDocument;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetNode;

class AllVariantsSkinPregenerator
implements SkinPregenerator {
    private SkinVariant _variant;
    private static final StyleSheetDocument _EMPTY_DOCUMENT = new StyleSheetDocument(new StyleSheetNode[0], null, -1L);
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(AllVariantsSkinPregenerator.class);

    AllVariantsSkinPregenerator() {
    }

    @Override
    public void pregenerate(FacesContext context, Skin skin, PregenConfig config, StyleProvider provider) {
        this._pregenerateWithStats(context, skin, config, provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _pregenerateWithStats(FacesContext context, Skin skin, PregenConfig config, StyleProvider provider) {
        Stats stats = new Stats(skin, config);
        stats.start();
        try {
            this._pregenerate(context, skin, config, provider, stats);
        }
        finally {
            stats.end();
        }
    }

    private void _pregenerate(FacesContext context, Skin skin, PregenConfig config, StyleProvider provider, Stats stats) {
        StyleSheetDocument document = this._getDocumentForSkin(context, skin, config, provider);
        this._pregenerateAllVariants(context, config, provider, document, stats);
    }

    private StyleSheetDocument _getDocumentForSkin(FacesContext context, Skin skin, PregenConfig config, StyleProvider provider) {
        StyleSheetDocument document = null;
        if (skin instanceof DocumentProviderSkin) {
            StyleContext styleContext = PregenStyleContext.documentContext(context, provider, config.getTargetDirectoryPath());
            document = ((DocumentProviderSkin)skin).getStyleSheetDocument(styleContext);
        }
        if (document == null) {
            _LOG.warning("SKIN_PREGEN_NO_DOCUMENT", (Object)skin.getId());
            document = _EMPTY_DOCUMENT;
        }
        return document;
    }

    private void _pregenerateAllVariants(FacesContext context, PregenConfig config, StyleProvider provider, StyleSheetDocument document, Stats stats) {
        SkinVariants variants = new SkinVariants(document, config);
        for (SkinVariant variant : variants) {
            this._pregenerateVariant(context, config, provider, variant, stats);
        }
    }

    private void _pregenerateVariant(FacesContext context, PregenConfig config, StyleProvider provider, SkinVariant variant, Stats stats) {
        StyleContext styleContext = this._createStyleContext(context, config, provider, variant);
        List<String> uris = provider.getStyleSheetURIs(styleContext);
        stats.variant(variant, uris);
        this._variant = variant;
    }

    private StyleContext _createStyleContext(FacesContext context, PregenConfig config, StyleProvider provider, SkinVariant variant) {
        assert (variant != null);
        return new PregenStyleContext(context, provider, config.getTargetDirectoryPath(), variant, this._isDirty(variant));
    }

    private boolean _isDirty(SkinVariant variant) {
        return this._variant != null && this._variant.getPlatform() != variant.getPlatform();
    }

    private class Stats {
        private final Skin _skin;
        private final String _targetDirectoryPath;
        private final Set<String> _uris = new HashSet<String>(101);
        private int _visitedVariantsCount = 0;
        private int _generatingVariantsCount = 0;
        private long _startTime = -1L;

        public Stats(Skin skin, PregenConfig config) {
            this._skin = skin;
            this._targetDirectoryPath = config.getTargetDirectoryPath();
        }

        public void start() {
            this._logStartMessage();
            this._startTime = System.currentTimeMillis();
        }

        public void variant(SkinVariant variant, List<String> uris) {
            ++this._visitedVariantsCount;
            if (this._isNewURI(uris)) {
                ++this._generatingVariantsCount;
                this._uris.addAll(uris);
            }
            this._logVariant(variant);
        }

        public void end() {
            long endTime = System.currentTimeMillis();
            this._logEndMessage(endTime);
        }

        private boolean _isNewURI(List<String> uris) {
            return uris != null && !uris.isEmpty() && !this._uris.contains(uris.get(0));
        }

        private void _logStartMessage() {
            _LOG.info("SKIN_PREGEN_STARTING", (Object)this._skin.getId());
        }

        private void _logEndMessage(long endTime) {
            long duration = endTime - this._startTime;
            _LOG.info("SKIN_PREGEN_COMPLETED", new Object[]{this._skin.getId(), this._uris.size(), this._generatingVariantsCount, this._visitedVariantsCount, duration, this._targetDirectoryPath});
        }

        private void _logVariant(SkinVariant variant) {
            assert (variant != null);
            int platform = variant.getPlatform();
            TrinidadAgent.Application agentApplication = variant.getApplicationAndVersion().application;
            if (AllVariantsSkinPregenerator.this._variant == null || platform != AllVariantsSkinPregenerator.this._variant.getPlatform() || agentApplication != ((AllVariantsSkinPregenerator)AllVariantsSkinPregenerator.this)._variant.getApplicationAndVersion().application) {
                _LOG.info("SKIN_PREGEN_VARIANT", new Object[]{NameUtils.getPlatformName(platform), agentApplication.getAgentName(), this._skin.getId()});
            }
        }
    }
}

