/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.xml.parse;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public class PropertyNode {
    private static final Map<String, String> _INTERNED_VALUES = new HashMap<String, String>();
    private static final Set<String> _INTERN_VALUES_FOR;
    private final String _name;
    private final String _value;
    private static final TrinidadLogger _LOG;

    public PropertyNode(String name, String value) {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException(_LOG.getMessage("PROPERTYNODE_NAME_CANNOT_BE_NULL_OR_EMPTY", new Object[]{name, value}));
        }
        this._name = name.intern();
        if (value != null) {
            if (_INTERN_VALUES_FOR.contains(name)) {
                value = value.intern();
            } else {
                String internedValue = _INTERNED_VALUES.get(value);
                if (internedValue != null) {
                    value = internedValue;
                }
            }
        }
        this._value = value;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PropertyNode)) {
            return false;
        }
        PropertyNode test = (PropertyNode)obj;
        return (this._value == test._value || this._value != null && this._value.equals(test._value)) && (this._name == test._name || this._name != null && this._name.equals(test._name));
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + (null == this._name ? 0 : this._name.hashCode());
        hash = 37 * hash + (null == this._value ? 0 : this._value.hashCode());
        return hash;
    }

    public String toString() {
        return "[name=" + this._name + ", " + "value=" + this._value + "]";
    }

    static {
        String[] internedValues = new String[]{"#000000", "#FFFFFF", "#ffffff", "0", "0%", "0px", "1", "10%", "100%", "1px", "1em", "2", "2px", "3px", "auto", "4px", "5px", "50%", "6px", "7px", "8px", "9px", "auto", "baseline", "black", "bottom", "center", "center center", "crosshair", "default", "e-resize", "gray", "help", "inherit", "left", "middle", "move", "n-resize", "ne-resize", "nw-resize", "none", "pointer", "progress", "right", "s-resize", "se-resize", "sub", "super", "sw-resize", "text", "text-bottom", "text-top", "top", "transparent", "w-resize", "wait", "white"};
        for (int i = 0; i < internedValues.length; ++i) {
            String internedValue = internedValues[i];
            _INTERNED_VALUES.put(internedValue, internedValue);
        }
        _INTERN_VALUES_FOR = new HashSet<String>(Arrays.asList("-moz-box-sizing", "background-repeat", "border-style", "display", "float", "font-family", "font-style", "font-weight", "list-style-position", "list-style-type", "overflow", "overflow-x", "overflow-y", "position", "text-align", "text-decoration", "transparent", "visibility", "white-space"));
        _LOG = TrinidadLogger.createTrinidadLogger(PropertyNode.class);
    }
}

