/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.resource.RegexResourceLoader;
import org.apache.myfaces.trinidad.resource.ResourceLoader;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidadinternal.resource.CoreClassLoaderResourceLoader;
import org.apache.myfaces.trinidadinternal.resource.CoreCommonScriptsResourceLoader;
import org.apache.myfaces.trinidadinternal.resource.CoreFormatScriptsResourceLoader;
import org.apache.myfaces.trinidadinternal.resource.LocaleElementsResourceLoader;

public class CoreRenderKitResourceLoader
extends RegexResourceLoader {
    private static final String _VERSION;
    private static final TrinidadLogger _LOG;

    public CoreRenderKitResourceLoader(ResourceLoader parent) {
        this.register("(/.*/Common.*\\.js)", (ResourceLoader)new CoreCommonScriptsResourceLoader(false));
        this.register("(/.*/DebugCommon.*\\.js)", (ResourceLoader)new CoreCommonScriptsResourceLoader(true));
        this.register("(/.*/CoreFmt.*\\.js)", (ResourceLoader)new CoreFormatScriptsResourceLoader(false));
        this.register("(/.*/DebugCoreFmt.*\\.js)", (ResourceLoader)new CoreFormatScriptsResourceLoader(true));
        this.register("(/.*LocaleElements.*\\.js)", (ResourceLoader)new LocaleElementsResourceLoader());
        this.register("(/.*\\.(css|cur|ico|jpg|gif|png|jpeg|svg|js))", (ResourceLoader)new CoreClassLoaderResourceLoader(parent));
    }

    public static String getLocaleElementsURI(String str, Boolean incVersion) {
        StringBuffer base = new StringBuffer("/adf/jsLibs/resources/");
        base.append(str);
        base.append("_");
        String locStr = CoreRenderKitResourceLoader.getLocale();
        base.append(locStr);
        if (incVersion.booleanValue()) {
            base.append(_VERSION);
        }
        base.append(".js");
        return base.toString();
    }

    public static String getLocale() {
        String path = ((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).getPathInfo();
        String locStr = "";
        int locIndex = path.indexOf("LocaleElements") + "LocaleElements_".length();
        int index = path.indexOf(_VERSION);
        if (index < 0) {
            index = path.indexOf(".js");
        }
        if (index >= 0) {
            locStr = path.substring(locIndex, index);
        }
        return locStr;
    }

    public static String __getVersion() {
        return _VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block11: {
            _LOG = TrinidadLogger.createTrinidadLogger(CoreRenderKitResourceLoader.class);
            String version = "unknown";
            try {
                URL resource = ClassLoaderUtils.getResource((String)"META-INF/trinidad-version.txt");
                if (resource == null) break block11;
                try (BufferedReader br = null;){
                    InputStream in = resource.openStream();
                    br = new BufferedReader(new InputStreamReader(in));
                    version = br.readLine();
                }
            }
            catch (IOException e) {
                _LOG.severe((Throwable)e);
            }
            finally {
                _VERSION = version;
            }
        }
    }
}

