/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.skin.SkinAddition;
import org.apache.myfaces.trinidad.skin.SkinMetadata;
import org.apache.myfaces.trinidad.skin.SkinProvider;
import org.apache.myfaces.trinidadinternal.skin.SkinExtension;
import org.apache.myfaces.trinidadinternal.skin.SkinUtils;
import org.apache.myfaces.trinidadinternal.skin.parse.SkinsNode;
import org.apache.myfaces.trinidadinternal.skin.provider.BaseSkinProvider;

public final class TrinidadSkinProvider
extends BaseSkinProvider {
    public static final String TRINDIAD_SKIN_PROVIDER_KEY = "org.apache.myfaces.trinidad.skin.TRINIDAD_SKIN_PROVIDER_INSTANCE";
    private List<SkinMetadata> _skinMetadata;
    private List<SkinAddition> _skinAdditionNodes;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TrinidadSkinProvider.class);

    public static TrinidadSkinProvider getCurrentInstance(ExternalContext ec) {
        if (ec == null) {
            throw new NullPointerException("ExternalContext is passed as null");
        }
        TrinidadSkinProvider trinidadSkinProvider = (TrinidadSkinProvider)((Object)ec.getApplicationMap().get(TRINDIAD_SKIN_PROVIDER_KEY));
        return trinidadSkinProvider;
    }

    @Override
    public Collection<SkinMetadata> getSkinMetadata(ExternalContext context) {
        this.initialize(context);
        return this._skinMetadata;
    }

    @Override
    protected Skin loadAvailableSkin(ExternalContext context, SkinMetadata skinMetadata) {
        SkinMetadata matchingNode = null;
        for (SkinMetadata node : this._skinMetadata) {
            if (!skinMetadata.getId().equals(node.getId())) continue;
            matchingNode = node;
            break;
        }
        if (matchingNode == null) {
            String message = _LOG.getMessage("SP_LOADING_UNKNOWN_SKIN", (Object)skinMetadata.getId());
            _LOG.severe(message);
            throw new IllegalArgumentException(message);
        }
        String id = matchingNode.getId();
        String family = matchingNode.getFamily();
        String renderKitId = matchingNode.getRenderKitId();
        Skin baseSkin = null;
        String baseSkinId = matchingNode.getBaseSkinId();
        SkinProvider provider = SkinProvider.getCurrentInstance((ExternalContext)context);
        if (provider != null && baseSkinId != null) {
            baseSkin = provider.getSkin(context, new SkinMetadata.Builder().id(baseSkinId).build());
        }
        if (baseSkin == null) {
            baseSkin = SkinUtils.getDefaultSkinForRenderKitId(provider, context, renderKitId);
        }
        if (id == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_SKIN_ID"));
        }
        if (family == null) {
            throw new NullPointerException("Null family");
        }
        _LOG.fine("Creating skin extension for skin metadata {0}", (Object)skinMetadata);
        return new SkinExtension(baseSkin, matchingNode, true);
    }

    @Override
    protected void initialize(ExternalContext extCtxt) {
        if (extCtxt == null) {
            throw new NullPointerException("ExternalContext is passed as null");
        }
        if (this._skinMetadata == null) {
            if (_LOG.isFine()) {
                _LOG.fine("init provider.");
            }
            List<SkinsNode> skinsNodes = SkinUtils.buildSkinsNodes(extCtxt);
            ArrayList<SkinMetadata> skinNodes = new ArrayList<SkinMetadata>();
            ArrayList<SkinAddition> skinAdditionNodes = new ArrayList<SkinAddition>();
            for (SkinsNode node : skinsNodes) {
                if (node == null) continue;
                skinNodes.addAll(node.getSkinNodes());
                skinAdditionNodes.addAll(node.getSkinAdditionNodes());
            }
            this._skinMetadata = skinNodes.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(skinNodes);
            this._skinAdditionNodes = skinAdditionNodes.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(skinAdditionNodes);
            if (_LOG.isFine()) {
                _LOG.fine("Number of skin metadata loaded from trinidad-skins.xml: {0}", (Object)this._skinMetadata.size());
                _LOG.fine("Number of skin additions loaded from trinidad-skins.xml: {0}", (Object)this._skinAdditionNodes.size());
            }
        }
    }

    void ensureSkinAdditions(Skin skin) {
        if (this._skinAdditionNodes == null || this._skinAdditionNodes.isEmpty()) {
            return;
        }
        for (SkinAddition addition : this._skinAdditionNodes) {
            this._checkAndAddInHierarchy(skin, addition);
        }
    }

    private void _checkAndAddInHierarchy(Skin skin, SkinAddition addition) {
        if (skin == null) {
            return;
        }
        String skinId = addition.getSkinId();
        if (skinId != null && skinId.equals(skin.getId())) {
            skin.addSkinAddition(addition);
        }
        this._checkAndAddInHierarchy(skin.getBaseSkin(), addition);
    }
}

