/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import org.apache.myfaces.trinidad.context.Version;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.Range;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.skin.AgentAtRuleMatcher;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.util.NameUtils;
import org.apache.myfaces.trinidadinternal.style.util.StyleSheetVisitUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetDocument;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetNode;

public final class StableNameUtils {
    private static final char _SEPARATOR = '-';
    private static final String _DEFAULT_PATH_TOKEN = "d";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(StableNameUtils.class);

    public static String getContextName(StyleContext context, StyleSheetDocument document) {
        return new ContextNameProducer(context, document).getName();
    }

    private static void _fail() {
        String message = _LOG.getMessage("SKIN_GENERATION_ERROR");
        throw new IllegalStateException(message);
    }

    private StableNameUtils() {
    }

    private static final class AccessibilityNameExtractor
    extends CollectionNameExtractor<String> {
        private AccessibilityNameExtractor() {
        }

        @Override
        protected Collection<String> getCollectionValues(StyleSheetNode styleSheet) {
            return styleSheet.getAccessibilityProperties();
        }

        @Override
        protected void mergeValues(StyleSheetNode styleSheet, Collection<String> oldAccessibilityProperties, Collection<String> newAccessibilityProperties) {
            oldAccessibilityProperties.addAll(newAccessibilityProperties);
        }

        @Override
        protected String toName(String accessibilityProperty) {
            String name = null;
            if ("high-contrast".equals(accessibilityProperty)) {
                name = "hc";
            }
            if ("large-fonts".equals(accessibilityProperty)) {
                name = "lf";
            }
            assert (name != null);
            return name;
        }
    }

    private static class DirectionNameExtractor
    implements NamingStyleSheetVisitor {
        private int _direction = 0;

        private DirectionNameExtractor() {
        }

        @Override
        public void visit(StyleSheetNode styleSheet) {
            int direction = styleSheet.getReadingDirection();
            if (direction != 0) {
                assert (this._direction == 0 || this._direction == direction);
                this._direction = direction;
            }
        }

        @Override
        public void appendName(StringBuilder builder) {
            String name = this._direction == 0 ? StableNameUtils._DEFAULT_PATH_TOKEN : NameUtils.getDirectionName(this._direction);
            builder.append(name);
        }
    }

    private static final class LocaleNameExtractor
    extends CollectionNameExtractor<Locale> {
        private LocaleNameExtractor() {
        }

        @Override
        protected Collection<Locale> getCollectionValues(StyleSheetNode styleSheet) {
            return styleSheet.getLocales();
        }

        @Override
        protected void mergeValues(StyleSheetNode styleSheet, Collection<Locale> oldLocales, Collection<Locale> newLocales) {
            assert (oldLocales != null);
            assert (newLocales != null);
            for (Locale newLocale : newLocales) {
                this._retainLocale(oldLocales, newLocale);
            }
        }

        private void _retainLocale(Collection<Locale> oldLocales, Locale newLocale) {
            Locale langOnlyLocale = this._toLanguageOnlyLocale(newLocale);
            Locale langAndCountryLocale = this._toLanguageAndCountryLocale(newLocale);
            if (oldLocales.contains(langOnlyLocale) || oldLocales.contains(langAndCountryLocale)) {
                oldLocales.remove(langOnlyLocale);
                oldLocales.remove(langAndCountryLocale);
                oldLocales.add(newLocale);
            }
        }

        private Locale _toLanguageOnlyLocale(Locale locale) {
            return new Locale(locale.getLanguage());
        }

        private Locale _toLanguageAndCountryLocale(Locale locale) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
    }

    private static class ApplicationNameExtractor
    extends CollectionNameExtractor<TrinidadAgent.Application> {
        private final Version _agentVersion;
        private Range<Version> _matchedVersions;

        public ApplicationNameExtractor(Version agentVersion) {
            assert (agentVersion != null);
            this._agentVersion = agentVersion;
            this._matchedVersions = Version.ALL_VERSIONS;
        }

        @Override
        protected String toName(TrinidadAgent.Application agentApplication) {
            return agentApplication.getAgentName();
        }

        @Override
        protected Collection<TrinidadAgent.Application> getCollectionValues(StyleSheetNode styleSheet) {
            AgentAtRuleMatcher agentMatcher = styleSheet.getAgentMatcher();
            if (agentMatcher == null) {
                return Collections.emptySet();
            }
            return agentMatcher.getAllApplications();
        }

        @Override
        protected void mergeValues(StyleSheetNode styleSheet, Collection<TrinidadAgent.Application> oldAgentApplications, Collection<TrinidadAgent.Application> newAgentApplications) {
            super.mergeValues(styleSheet, oldAgentApplications, newAgentApplications);
            TrinidadAgent.Application newAgentApplication = this._getSingleAgentApplication(newAgentApplications);
            if (newAgentApplication != null) {
                this._mergeVersions(styleSheet.getAgentMatcher(), newAgentApplication);
            }
        }

        private TrinidadAgent.Application _getSingleAgentApplication(Collection<TrinidadAgent.Application> agentApplications) {
            Iterator<TrinidadAgent.Application> iter;
            if (agentApplications.size() == 1 && (iter = agentApplications.iterator()).hasNext()) {
                return iter.next();
            }
            return null;
        }

        private void _mergeVersions(AgentAtRuleMatcher agentMatcher, TrinidadAgent.Application agentApplication) {
            assert (agentMatcher != null);
            assert (agentApplication != null);
            Range<Version> matchedVersions = agentMatcher.getMatchedVersionsForApplication(agentApplication, this._agentVersion);
            this._matchedVersions = this._matchedVersions.intersect(matchedVersions);
            if (this._matchedVersions.isEmpty()) {
                StableNameUtils._fail();
            }
        }

        @Override
        public void appendName(StringBuilder builder) {
            super.appendName(builder);
            builder.append('-');
            this._appendVersionName(builder);
        }

        private void _appendVersionName(StringBuilder builder) {
            Version startVersion = (Version)this._matchedVersions.getStart();
            Version endVersion = (Version)this._matchedVersions.getEnd();
            boolean startMin = startVersion.equals((Object)Version.MIN_VERSION);
            boolean endMax = endVersion.equals((Object)Version.MAX_VERSION);
            if (startMin && endMax) {
                builder.append(StableNameUtils._DEFAULT_PATH_TOKEN);
            } else if (startMin) {
                builder.append(endVersion);
                builder.append("m");
            } else if (endMax) {
                builder.append(startVersion);
                builder.append("p");
            } else {
                builder.append(startVersion);
            }
        }
    }

    private static final class PlatformNameExtractor
    extends CollectionNameExtractor<Integer> {
        private PlatformNameExtractor() {
        }

        @Override
        protected Collection<Integer> getCollectionValues(StyleSheetNode styleSheet) {
            return styleSheet.getPlatforms();
        }

        @Override
        protected String toName(Integer platform) {
            return NameUtils.getPlatformName(platform);
        }
    }

    private static abstract class CollectionNameExtractor<E>
    implements NamingStyleSheetVisitor {
        private Collection<E> _values = null;

        private CollectionNameExtractor() {
        }

        protected abstract Collection<E> getCollectionValues(StyleSheetNode var1);

        @Override
        public void visit(StyleSheetNode styleSheet) {
            Collection<E> newValues = this.getCollectionValues(styleSheet);
            if (!newValues.isEmpty()) {
                if (this._values == null) {
                    this._values = new HashSet<E>(newValues);
                } else {
                    this.mergeValues(styleSheet, this._values, newValues);
                    if (this._values.isEmpty()) {
                        StableNameUtils._fail();
                    }
                }
            }
        }

        protected void mergeValues(StyleSheetNode styleSheet, Collection<E> oldValues, Collection<E> newValues) {
            oldValues.retainAll(newValues);
        }

        @Override
        public void appendName(StringBuilder builder) {
            if (this._values == null) {
                builder.append(StableNameUtils._DEFAULT_PATH_TOKEN);
            } else {
                assert (this._values != null);
                assert (!this._values.isEmpty());
                Collection<String> names = this._toNames(this._values);
                this._appendNames(builder, names);
            }
        }

        private Collection<String> _toNames(Collection<E> values) {
            TreeSet<String> names = new TreeSet<String>();
            for (E value : values) {
                String name = this.toName(value);
                assert (name != null);
                names.add(name);
            }
            return names;
        }

        protected String toName(E value) {
            return value.toString();
        }

        private void _appendNames(StringBuilder builder, Collection<String> names) {
            assert (names != null);
            assert (!names.isEmpty());
            Iterator<String> iter = names.iterator();
            while (iter.hasNext()) {
                builder.append(iter.next());
                if (!iter.hasNext()) continue;
                builder.append("_");
            }
        }
    }

    private static interface NamingStyleSheetVisitor
    extends StyleSheetVisitUtils.StyleSheetVisitor {
        public void appendName(StringBuilder var1);
    }

    private static final class ContextNameProducer {
        private final StyleContext _context;
        private final String _documentId;
        private final Collection<StyleSheetNode> _styleSheets;

        public ContextNameProducer(StyleContext context, StyleSheetDocument document) {
            this._context = context;
            this._documentId = document.getDocumentId(context);
            this._styleSheets = document.getStyleSheetsAsCollection(context);
        }

        public String getName() {
            Collection<NamingStyleSheetVisitor> visitors = this._getVisitors();
            this._visitStyleSheets(visitors);
            return this._toName(visitors);
        }

        private Collection<NamingStyleSheetVisitor> _getVisitors() {
            return Arrays.asList(new PlatformNameExtractor(), new ApplicationNameExtractor(this._context.getAgent().getVersion()), new LocaleNameExtractor(), new DirectionNameExtractor(), new AccessibilityNameExtractor());
        }

        private void _visitStyleSheets(Collection<? extends StyleSheetVisitUtils.StyleSheetVisitor> visitors) {
            StyleSheetVisitUtils.StyleSheetVisitor compoundVisitor = StyleSheetVisitUtils.compoundStyleSheetVisitor(visitors);
            StyleSheetVisitUtils.visitStyleSheets(this._styleSheets, compoundVisitor);
        }

        private String _toName(Collection<NamingStyleSheetVisitor> visitors) {
            StringBuilder builder = new StringBuilder(100);
            this._appendSkinIdentifierSection(builder);
            this._appendVariantsSection(builder, visitors);
            this._appendContextualSection(builder);
            this._appendSuffix(builder);
            return builder.toString();
        }

        private void _appendSkinIdentifierSection(StringBuilder builder) {
            builder.append(this._documentId);
            builder.append('-');
            builder.append('-');
        }

        private void _appendVariantsSection(StringBuilder builder, Collection<NamingStyleSheetVisitor> visitors) {
            for (NamingStyleSheetVisitor visitor : visitors) {
                visitor.appendName(builder);
                builder.append('-');
            }
            builder.append('-');
        }

        private void _appendContextualSection(StringBuilder builder) {
            builder.append(this._context.isPortletMode() ? "p" : "s");
            builder.append('-');
            builder.append(this._context.isRequestSecure() ? "s" : "n");
            builder.append('-');
            builder.append(this._context.isDisableStyleCompression() ? "u" : "c");
        }

        private void _appendSuffix(StringBuilder builder) {
            builder.append(".css");
        }
    }
}

