// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
*/
package org.apache.myfaces.trinidad.component.html;

import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.util.ComponentUtils;

/**
 *
 * <html:p>
 *             The meta component supports generating an html meta tag for things like reloading the page or configuring viewport characteristics like these:
 *             <html:ul>
 *               <html:li><html:pre>&lt;meta name="viewport" content="width=device-width, user-scalable=no"&gt;</html:pre></html:li>
 *               <html:li><html:pre>&lt;meta name="apple-mobile-web-app-capable" content="yes"&gt;</html:pre></html:li>
 *               <html:li><html:pre>&lt;meta http-equiv="refresh" content="2;url=./test/index.jspx"&gt;</html:pre></html:li>
 *             </html:ul>
 *             It is also important to note that a meta HTML tag cannot have an ID so the component ID will not be seen in the browser source.
 * 	  </html:p>
 *
 * <h4>Events:</h4>
 * <table border="1" width="100%" cellpadding="3" summary="">
 * <tr bgcolor="#CCCCFF" class="TableHeadingColor">
 * <th align="left">Type</th>
 * <th align="left">Phases</th>
 * <th align="left">Description</th>
 * </tr>
 * <tr class="TableRowColor">
 * <td valign="top"><code>org.apache.myfaces.trinidad.event.AttributeChangeEvent</code></td>
 * <td valign="top" nowrap>Invoke<br>Application<br>Apply<br>Request<br>Values</td>
 * <td valign="top">Event delivered to describe an attribute change.  Attribute change events are not delivered for any programmatic change to a property.  They are only delivered when a renderer changes a property without the application's specific request.  An example of an attribute change event might include the width of a column that supported client-side resizing.</td>
 * </tr>
 * </table>
 */
public class HtmlMeta extends UIXComponentBase
{
  static public final String TYPE_NAME = "name";
  static public final String TYPE_HTTP_EQUIV = "httpEquiv";
  static public final FacesBean.Type TYPE = new FacesBean.Type(
    UIXComponentBase.TYPE);
  static public final PropertyKey NAME_KEY =
    TYPE.registerKey("name", String.class);
  static public final PropertyKey TYPE_KEY =
    TYPE.registerKey("type", String.class, "name");
  static public final PropertyKey CONTENT_KEY =
    TYPE.registerKey("content", String.class);

  static public final String COMPONENT_FAMILY =
    "org.apache.myfaces.trinidad.Meta";
  static public final String COMPONENT_TYPE =
    "org.apache.myfaces.trinidad.HtmlMeta";

  /**
   * Construct an instance of the HtmlMeta.
   */
  public HtmlMeta()
  {
    super("org.apache.myfaces.trinidad.Meta");
  }

  /**
   * Gets the	name or the http-equiv attribute for the meta tag (see the type attribute for further configuration)
   *
   * @return  the new name value
   */
  final public String getName()
  {
    return ComponentUtils.resolveString(getProperty(NAME_KEY));
  }

  /**
   * Sets the	name or the http-equiv attribute for the meta tag (see the type attribute for further configuration)
   * 
   * @param name  the new name value
   */
  final public void setName(String name)
  {
    setProperty(NAME_KEY, (name));
  }

  /**
   * Gets <html>how the name attribute is used.  Options are:
   *               <ul><li>name - for "name" which is the most common use for meta tags
   *                 </li><li>httpEquiv - for "http-equiv" which is the used in some legacy meta tags
   *                 </li></ul>
   *               </html>
   *
   * @return  the new type value
   */
  final public String getType()
  {
    return ComponentUtils.resolveString(getProperty(TYPE_KEY), "name");
  }

  /**
   * Sets <html>how the name attribute is used.  Options are:
   *               <ul><li>name - for "name" which is the most common use for meta tags
   *                 </li><li>httpEquiv - for "http-equiv" which is the used in some legacy meta tags
   *                 </li></ul>
   *               </html>
   * 
   * @param type  the new type value
   */
  final public void setType(String type)
  {
    setProperty(TYPE_KEY, (type));
  }

  /**
   * Gets the	content for the meta tag
   *
   * @return  the new content value
   */
  final public String getContent()
  {
    return ComponentUtils.resolveString(getProperty(CONTENT_KEY));
  }

  /**
   * Sets the	content for the meta tag
   * 
   * @param content  the new content value
   */
  final public void setContent(String content)
  {
    setProperty(CONTENT_KEY, (content));
  }

  @Override
  public String getFamily()
  {
    return COMPONENT_FAMILY;
  }

  @Override
  protected FacesBean.Type getBeanType()
  {
    return TYPE;
  }

  /**
   * Construct an instance of the HtmlMeta.
   */
  protected HtmlMeta(
    String rendererType
    )
  {
    super(rendererType);
  }

  static
  {
    TYPE.lockAndRegister("org.apache.myfaces.trinidad.Meta","org.apache.myfaces.trinidad.Meta");
  }
}
