/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeException;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeListener;
import org.apache.nifi.minifi.bootstrap.service.BootstrapFileProvider;
import org.apache.nifi.minifi.bootstrap.util.ConfigTransformer;
import org.slf4j.Logger;

public class MiNiFiConfigurationChangeListener
implements ConfigurationChangeListener {
    private final RunMiNiFi runner;
    private final Logger logger;
    private final BootstrapFileProvider bootstrapFileProvider;
    private static final ReentrantLock handlingLock = new ReentrantLock();

    public MiNiFiConfigurationChangeListener(RunMiNiFi runner, Logger logger, BootstrapFileProvider bootstrapFileProvider) {
        this.runner = runner;
        this.logger = logger;
        this.bootstrapFileProvider = bootstrapFileProvider;
    }

    @Override
    public void handleChange(InputStream configInputStream) throws ConfigurationChangeException {
        this.logger.info("Received notification of a change");
        if (!handlingLock.tryLock()) {
            throw new ConfigurationChangeException("Instance is already handling another change");
        }
        try {
            Properties bootstrapProperties = this.bootstrapFileProvider.getBootstrapProperties();
            File configFile = new File(bootstrapProperties.getProperty("nifi.minifi.config"));
            File swapConfigFile = this.bootstrapFileProvider.getConfigYmlSwapFile();
            this.logger.info("Persisting old configuration to {}", (Object)swapConfigFile.getAbsolutePath());
            try (FileInputStream configFileInputStream = new FileInputStream(configFile);){
                Files.copy(configFileInputStream, swapConfigFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            Files.copy(configInputStream, configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            var6_7 = null;
            try (FileInputStream newConfigIs = new FileInputStream(configFile);){
                try {
                    String confDir = bootstrapProperties.getProperty("conf.dir");
                    this.transformConfigurationFiles(confDir, newConfigIs, configFile, swapConfigFile);
                }
                catch (Exception e) {
                    this.logger.debug("Transformation of new config file failed after swap file was created, deleting it.");
                    if (!swapConfigFile.delete()) {
                        this.logger.warn("The swap file failed to delete after a failed handling of a change. It should be cleaned up manually.");
                    }
                    throw e;
                }
            }
            catch (Throwable throwable) {
                var6_7 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new ConfigurationChangeException("Unable to perform reload of received configuration change", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)configInputStream);
            handlingLock.unlock();
        }
    }

    @Override
    public String getDescriptor() {
        return "MiNiFiConfigurationChangeListener";
    }

    private void transformConfigurationFiles(String confDir, FileInputStream newConfigIs, File configFile, File swapConfigFile) throws Exception {
        try {
            this.logger.info("Performing transformation for input and saving outputs to {}", (Object)confDir);
            ByteBuffer tempConfigFile = ConfigTransformer.generateConfigFiles(newConfigIs, confDir, this.bootstrapFileProvider.getBootstrapProperties());
            this.runner.getConfigFileReference().set(tempConfigFile.asReadOnlyBuffer());
            this.reloadNewConfiguration(swapConfigFile, confDir);
        }
        catch (Exception e) {
            this.logger.debug("Transformation of new config file failed after replacing original with the swap file, reverting.");
            try (FileInputStream swapConfigFileStream = new FileInputStream(swapConfigFile);){
                Files.copy(swapConfigFileStream, configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            throw e;
        }
    }

    private void reloadNewConfiguration(File swapConfigFile, String confDir) throws Exception {
        try {
            this.logger.info("Reloading instance with new configuration");
            this.restartInstance();
        }
        catch (Exception e) {
            this.logger.debug("Transformation of new config file failed after transformation into Flow.xml and nifi.properties, reverting.");
            try (FileInputStream swapConfigFileStream = new FileInputStream(swapConfigFile);){
                ByteBuffer resetConfigFile = ConfigTransformer.generateConfigFiles(swapConfigFileStream, confDir, this.bootstrapFileProvider.getBootstrapProperties());
                this.runner.getConfigFileReference().set(resetConfigFile.asReadOnlyBuffer());
            }
            throw e;
        }
    }

    private void restartInstance() throws IOException {
        try {
            this.runner.reload();
        }
        catch (IOException e) {
            throw new IOException("Unable to successfully restart MiNiFi instance after configuration change.", e);
        }
    }
}

