/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.web.util.WebUtils;

public class RequestUriBuilder {
    private static final String ALLOWED_CONTEXT_PATHS_PARAMETER = "allowedContextPaths";
    private static final String COMMA_SEPARATOR = ",";
    private final String scheme;
    private final String host;
    private final int port;
    private final String contextPath;
    private String path;

    private RequestUriBuilder(String scheme, String host, int port, String contextPath) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.contextPath = contextPath;
    }

    public static RequestUriBuilder fromHttpServletRequest(HttpServletRequest httpServletRequest) {
        List<String> allowedContextPaths = RequestUriBuilder.getAllowedContextPathsConfigured(httpServletRequest);
        return RequestUriBuilder.fromHttpServletRequest(httpServletRequest, allowedContextPaths);
    }

    public static RequestUriBuilder fromHttpServletRequest(HttpServletRequest httpServletRequest, List<String> allowedContextPaths) {
        String scheme = (String)StringUtils.defaultIfEmpty((CharSequence)WebUtils.determineProxiedScheme(httpServletRequest), (CharSequence)httpServletRequest.getScheme());
        String host = WebUtils.determineProxiedHost(httpServletRequest);
        int port = WebUtils.getServerPort(httpServletRequest);
        String contextPath = WebUtils.determineContextPath(httpServletRequest);
        WebUtils.verifyContextPath(allowedContextPaths, contextPath);
        return new RequestUriBuilder(scheme, host, port, contextPath);
    }

    public RequestUriBuilder path(String path) {
        this.path = path;
        return this;
    }

    public URI build() {
        String resourcePath = StringUtils.join((Object[])new String[]{this.contextPath, this.path});
        try {
            return new URI(this.scheme, null, this.host, this.port, resourcePath, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Build URI Failed", e);
        }
    }

    private static List<String> getAllowedContextPathsConfigured(HttpServletRequest httpServletRequest) {
        ServletContext servletContext = httpServletRequest.getServletContext();
        String allowedContextPathsParameter = servletContext.getInitParameter(ALLOWED_CONTEXT_PATHS_PARAMETER);
        String[] allowedContextPathsParsed = StringUtils.split((String)allowedContextPathsParameter, (String)COMMA_SEPARATOR);
        return allowedContextPathsParsed == null ? Collections.emptyList() : Arrays.asList(allowedContextPathsParsed);
    }
}

