/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.repository.schema;

import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordField;
import org.apache.nifi.repository.schema.RecordSchema;

public class FieldMapRecord
implements Record {
    private final Map<String, Object> values;
    private final RecordSchema schema;

    public FieldMapRecord(Map<RecordField, Object> values, RecordSchema schema) {
        this.schema = schema;
        this.values = FieldMapRecord.convertFieldToName(values);
    }

    public FieldMapRecord(RecordSchema schema, Map<String, Object> values) {
        this.schema = schema;
        this.values = new HashMap<String, Object>(values);
    }

    private static Map<String, Object> convertFieldToName(Map<RecordField, Object> map) {
        HashMap<String, Object> nameMap = new HashMap<String, Object>(map.size());
        for (Map.Entry<RecordField, Object> entry : map.entrySet()) {
            nameMap.put(entry.getKey().getFieldName(), entry.getValue());
        }
        return nameMap;
    }

    @Override
    public Object getFieldValue(RecordField field) {
        return this.values.get(field.getFieldName());
    }

    @Override
    public RecordSchema getSchema() {
        return this.schema;
    }

    @Override
    public Object getFieldValue(String fieldName) {
        return this.values.get(fieldName);
    }

    public String toString() {
        return "FieldMapRecord[" + this.values + "]";
    }

    public int hashCode() {
        return 33 + 41 * this.values.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FieldMapRecord)) {
            return false;
        }
        FieldMapRecord other = (FieldMapRecord)obj;
        return this.values.equals(other.values);
    }
}

