/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.util.Objects;
import org.apache.nifi.parameter.ParameterUpdate;

public class StandardParameterUpdate
implements ParameterUpdate {
    private final String parameterName;
    private final String previousValue;
    private final String updatedValue;
    private final boolean sensitiveParameter;

    public StandardParameterUpdate(String parameterName, String previousValue, String updatedValue, boolean sensitiveParameter) {
        this.parameterName = parameterName;
        this.previousValue = previousValue;
        this.updatedValue = updatedValue;
        this.sensitiveParameter = sensitiveParameter;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getPreviousValue() {
        return this.previousValue;
    }

    public String getUpdatedValue() {
        return this.updatedValue;
    }

    public boolean isSensitive() {
        return this.sensitiveParameter;
    }

    public String toString() {
        if (this.sensitiveParameter) {
            return "StandardParameterUpdate[parameterName=" + this.parameterName + ", sensitive=true]";
        }
        return "StandardParameterUpdate[parameterName=" + this.parameterName + ", sensitive=false, previous value='" + this.previousValue + "', updated value='" + this.updatedValue + "']";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StandardParameterUpdate)) {
            return false;
        }
        StandardParameterUpdate that = (StandardParameterUpdate)o;
        return Objects.equals(this.parameterName, that.parameterName) && Objects.equals(this.previousValue, that.previousValue) && Objects.equals(this.updatedValue, that.updatedValue);
    }

    public int hashCode() {
        return Objects.hash(this.parameterName, this.previousValue, this.updatedValue);
    }
}

