/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql;

import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.std.BinarySequence;
import io.questdb.std.Long256;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class VirtualRecord
implements ColumnTypes,
Record {
    private final int columnCount;
    private final ObjList<? extends Function> functions;
    private Record base;

    public VirtualRecord(ObjList<? extends Function> functions) {
        this.functions = functions;
        this.columnCount = functions.size();
    }

    public Record getBaseRecord() {
        return this.base;
    }

    @Override
    public BinarySequence getBin(int col) {
        return this.getFunction(col).getBin(this.base);
    }

    @Override
    public long getBinLen(int col) {
        return this.getFunction(col).getBinLen(this.base);
    }

    @Override
    public boolean getBool(int col) {
        return this.getFunction(col).getBool(this.base);
    }

    @Override
    public byte getByte(int col) {
        return this.getFunction(col).getByte(this.base);
    }

    @Override
    public char getChar(int col) {
        return this.getFunction(col).getChar(this.base);
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getColumnType(int columnIndex) {
        return this.getFunction(columnIndex).getType();
    }

    @Override
    public long getDate(int col) {
        return this.getFunction(col).getDate(this.base);
    }

    @Override
    public double getDouble(int col) {
        return this.getFunction(col).getDouble(this.base);
    }

    @Override
    public float getFloat(int col) {
        return this.getFunction(col).getFloat(this.base);
    }

    public ObjList<? extends Function> getFunctions() {
        return this.functions;
    }

    @Override
    public byte getGeoByte(int col) {
        return this.getFunction(col).getGeoByte(this.base);
    }

    @Override
    public int getGeoInt(int col) {
        return this.getFunction(col).getGeoInt(this.base);
    }

    @Override
    public long getGeoLong(int col) {
        return this.getFunction(col).getGeoLong(this.base);
    }

    @Override
    public short getGeoShort(int col) {
        return this.getFunction(col).getGeoShort(this.base);
    }

    @Override
    public int getInt(int col) {
        return this.getFunction(col).getInt(this.base);
    }

    @Override
    public long getLong(int col) {
        return this.getFunction(col).getLong(this.base);
    }

    @Override
    public long getLong128Hi(int col) {
        return this.getFunction(col).getLong128Hi(this.base);
    }

    @Override
    public long getLong128Lo(int col) {
        return this.getFunction(col).getLong128Lo(this.base);
    }

    @Override
    public void getLong256(int col, CharSink sink) {
        this.getFunction(col).getLong256(this.base, sink);
    }

    @Override
    public Long256 getLong256A(int col) {
        return this.getFunction(col).getLong256A(this.base);
    }

    @Override
    public Long256 getLong256B(int col) {
        return this.getFunction(col).getLong256B(this.base);
    }

    @Override
    public Record getRecord(int col) {
        return this.getFunction(col).getRecord(this.base);
    }

    @Override
    public long getRowId() {
        return this.base.getRowId();
    }

    @Override
    public short getShort(int col) {
        return this.getFunction(col).getShort(this.base);
    }

    @Override
    public CharSequence getStr(int col) {
        return this.getFunction(col).getStr(this.base);
    }

    @Override
    public void getStr(int col, CharSink sink) {
        this.getFunction(col).getStr(this.base, sink);
    }

    @Override
    public CharSequence getStrB(int col) {
        return this.getFunction(col).getStrB(this.base);
    }

    @Override
    public int getStrLen(int col) {
        return this.getFunction(col).getStrLen(this.base);
    }

    @Override
    public CharSequence getSym(int col) {
        return this.getFunction(col).getSymbol(this.base);
    }

    @Override
    public CharSequence getSymB(int col) {
        return this.getFunction(col).getSymbolB(this.base);
    }

    @Override
    public long getTimestamp(int col) {
        return this.getFunction(col).getTimestamp(this.base);
    }

    @Override
    public long getUpdateRowId() {
        return this.base.getUpdateRowId();
    }

    public void of(Record record) {
        this.base = record;
    }

    private Function getFunction(int columnIndex) {
        return this.functions.getQuick(columnIndex);
    }
}

