/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableReaderSelectedColumnRecord;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.std.IntList;

class SymbolIndexFilteredRowCursor
implements RowCursor {
    private final boolean cachedIndexReaderCursor;
    private final int columnIndex;
    private final Function filter;
    private final int indexDirection;
    private final TableReaderSelectedColumnRecord record;
    private RowCursor rowCursor;
    private long rowid;
    private int symbolKey;

    public SymbolIndexFilteredRowCursor(int columnIndex, int symbolKey, Function filter, boolean cachedIndexReaderCursor, int indexDirection, IntList columnIndexes) {
        this(columnIndex, filter, cachedIndexReaderCursor, indexDirection, columnIndexes);
        this.of(symbolKey);
    }

    public SymbolIndexFilteredRowCursor(int columnIndex, Function filter, boolean cachedIndexReaderCursor, int indexDirection, IntList columnIndexes) {
        this.columnIndex = columnIndex;
        this.filter = filter;
        this.cachedIndexReaderCursor = cachedIndexReaderCursor;
        this.indexDirection = indexDirection;
        this.record = new TableReaderSelectedColumnRecord(columnIndexes);
    }

    @Override
    public boolean hasNext() {
        while (this.rowCursor.hasNext()) {
            long rowid = this.rowCursor.next();
            this.record.setRecordIndex(rowid);
            if (!this.filter.getBool(this.record)) continue;
            this.rowid = rowid;
            return true;
        }
        return false;
    }

    @Override
    public long next() {
        return this.rowid;
    }

    public final void of(int symbolKey) {
        this.symbolKey = TableUtils.toIndexKey(symbolKey);
    }

    public SymbolIndexFilteredRowCursor of(DataFrame dataFrame) {
        this.rowCursor = dataFrame.getBitmapIndexReader(this.columnIndex, this.indexDirection).getCursor(this.cachedIndexReaderCursor, this.symbolKey, dataFrame.getRowLo(), dataFrame.getRowHi() - 1L);
        this.record.jumpTo(dataFrame.getPartitionIndex(), 0L);
        return this;
    }

    int getColumnIndex() {
        return this.columnIndex;
    }

    Function getFilter() {
        return this.filter;
    }

    int getIndexDirection() {
        return this.indexDirection;
    }

    int getSymbolKey() {
        return this.symbolKey;
    }

    void prepare(TableReader tableReader) {
        this.record.of(tableReader);
    }
}

