/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.metrics;

import io.questdb.metrics.Counter;
import io.questdb.metrics.PrometheusFormatUtils;
import io.questdb.std.str.CharSink;
import java.util.concurrent.atomic.LongAdder;

class CounterImpl
implements Counter {
    private final LongAdder counter;
    private final CharSequence name;

    CounterImpl(CharSequence name) {
        this.name = name;
        this.counter = new LongAdder();
    }

    @Override
    public void add(long value) {
        this.counter.add(value);
    }

    @Override
    public long getValue() {
        return this.counter.sum();
    }

    @Override
    public void scrapeIntoPrometheus(CharSink sink) {
        PrometheusFormatUtils.appendCounterType(this.name, sink);
        PrometheusFormatUtils.appendCounterNamePrefix(this.name, sink);
        PrometheusFormatUtils.appendSampleLineSuffix(sink, this.counter.longValue());
        PrometheusFormatUtils.appendNewLine(sink);
    }
}

