/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.std.Chars;
import io.questdb.std.Unsafe;
import io.questdb.std.str.ByteCharSequence;
import io.questdb.std.str.DirectByteCharSequence;

public final class Hash {
    private static final long M2 = 2053402189L;
    private static final int SPREAD_HASH_BITS = Integer.MAX_VALUE;

    private Hash() {
    }

    public static int boundedHash(CharSequence seq, int max) {
        return seq == null ? -1 : Chars.hashCode(seq) & 0xFFFFFFF & max;
    }

    public static long fastLongMix(long k) {
        long phi = -7046029254386353131L;
        long h = k * -7046029254386353131L;
        h ^= h >>> 32;
        return h ^ h >>> 16;
    }

    public static int hash(long key1, long key2) {
        return (int)Hash.fastLongMix(Hash.fastLongMix(key1) + key2);
    }

    public static int hashMem32(DirectByteCharSequence seq) {
        return Hash.hashMem32(seq.getLo(), seq.length());
    }

    public static int hashMem32(ByteCharSequence seq) {
        int len = seq.length();
        long h = 0L;
        int i = 0;
        while (i + 7 < len) {
            h = h * 2053402189L + seq.longAt(i);
            i += 8;
        }
        if (i + 3 < len) {
            h = h * 2053402189L + (long)seq.intAt(i);
            i += 4;
        }
        while (i < len) {
            h = h * 2053402189L + (long)seq.byteAt(i);
            ++i;
        }
        return (int)(h *= 2053402189L) ^ (int)(h >>> 32);
    }

    public static int hashMem32(long p, long len) {
        long h = 0L;
        int i = 0;
        while ((long)(i + 7) < len) {
            h = h * 2053402189L + Unsafe.getUnsafe().getLong(p + (long)i);
            i += 8;
        }
        if ((long)(i + 3) < len) {
            h = h * 2053402189L + (long)Unsafe.getUnsafe().getInt(p + (long)i);
            i += 4;
        }
        while ((long)i < len) {
            h = h * 2053402189L + (long)Unsafe.getUnsafe().getByte(p + (long)i);
            ++i;
        }
        return (int)(h *= 2053402189L) ^ (int)(h >>> 32);
    }

    public static int hashMem32(long p, long len, MemoryR mem) {
        long h = 0L;
        int i = 0;
        while ((long)(i + 7) < len) {
            h = h * 2053402189L + mem.getLong(p + (long)i);
            i += 8;
        }
        if ((long)(i + 3) < len) {
            h = h * 2053402189L + (long)mem.getInt(p + (long)i);
            i += 4;
        }
        while ((long)i < len) {
            h = h * 2053402189L + (long)mem.getByte(p + (long)i);
            ++i;
        }
        return (int)(h *= 2053402189L) ^ (int)(h >>> 32);
    }

    public static int spread(int h) {
        return (h ^ h >>> 16) & Integer.MAX_VALUE;
    }
}

