/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.datetime.millitime;

import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.millitime.DateFormatCompiler;
import java.util.function.Function;

public class DateFormatFactory {
    private static final ThreadLocal<DateFormatCompiler> tlCompiler = ThreadLocal.withInitial(DateFormatCompiler::new);
    private static final Function<CharSequence, DateFormat> mapper = DateFormatFactory::map;
    private final ConcurrentHashMap<DateFormat> cache = new ConcurrentHashMap();

    public DateFormat get(CharSequence pattern) {
        return this.cache.computeIfAbsent(pattern, mapper);
    }

    private static DateFormat map(CharSequence value) {
        return tlCompiler.get().compile(value);
    }
}

