/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.cluster.protocol.ProtocolContext;
import org.apache.nifi.cluster.protocol.ProtocolException;
import org.apache.nifi.cluster.protocol.ProtocolHandler;
import org.apache.nifi.cluster.protocol.ProtocolListener;
import org.apache.nifi.cluster.protocol.ProtocolMessageMarshaller;
import org.apache.nifi.cluster.protocol.ProtocolMessageUnmarshaller;
import org.apache.nifi.cluster.protocol.impl.CopyingInputStream;
import org.apache.nifi.cluster.protocol.message.ConnectionRequestMessage;
import org.apache.nifi.cluster.protocol.message.DisconnectMessage;
import org.apache.nifi.cluster.protocol.message.FlowRequestMessage;
import org.apache.nifi.cluster.protocol.message.HeartbeatMessage;
import org.apache.nifi.cluster.protocol.message.OffloadMessage;
import org.apache.nifi.cluster.protocol.message.ProtocolMessage;
import org.apache.nifi.cluster.protocol.message.ReconnectionRequestMessage;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.io.socket.ServerSocketConfiguration;
import org.apache.nifi.io.socket.SocketListener;
import org.apache.nifi.io.socket.SocketUtils;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.security.cert.PeerIdentityProvider;
import org.apache.nifi.security.cert.StandardPeerIdentityProvider;
import org.apache.nifi.stream.io.ByteCountingInputStream;
import org.apache.nifi.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketProtocolListener
extends SocketListener
implements ProtocolListener {
    private static final Logger logger = LoggerFactory.getLogger(SocketProtocolListener.class);
    private final PeerIdentityProvider peerIdentityProvider = new StandardPeerIdentityProvider();
    private final ProtocolContext<ProtocolMessage> protocolContext;
    private final Collection<ProtocolHandler> handlers = new CopyOnWriteArrayList<ProtocolHandler>();
    private volatile BulletinRepository bulletinRepository;
    private static final int EXCEPTION_THRESHOLD_MILLIS = 10000;
    private volatile long tlsErrorLastSeen = -1L;

    public SocketProtocolListener(int numThreads, int port, ServerSocketConfiguration configuration, ProtocolContext<ProtocolMessage> protocolContext) {
        super(numThreads, port, configuration);
        if (protocolContext == null) {
            throw new IllegalArgumentException("Protocol Context may not be null.");
        }
        this.protocolContext = protocolContext;
    }

    @Override
    public void setBulletinRepository(BulletinRepository bulletinRepository) {
        this.bulletinRepository = bulletinRepository;
    }

    @Override
    public void start() throws IOException {
        if (super.isRunning()) {
            throw new IllegalStateException("Instance is already started.");
        }
        super.start();
    }

    @Override
    public void stop() throws IOException {
        if (!super.isRunning()) {
            throw new IOException("Instance is already stopped.");
        }
        super.stop();
    }

    @Override
    public Collection<ProtocolHandler> getHandlers() {
        return Collections.unmodifiableCollection(this.handlers);
    }

    @Override
    public void addHandler(ProtocolHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Protocol handler may not be null.");
        }
        this.handlers.add(handler);
    }

    @Override
    public boolean removeHandler(ProtocolHandler handler) {
        return this.handlers.remove(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchRequest(Socket socket) {
        String hostname = null;
        try {
            ProtocolMessage request;
            CopyingInputStream copyingInputStream;
            ByteCountingInputStream countingIn;
            StopWatch stopWatch = new StopWatch(true);
            hostname = socket.getInetAddress().getHostName();
            String requestId = UUID.randomUUID().toString();
            logger.debug("Received request {} from {}", (Object)requestId, (Object)hostname);
            ProtocolMessageUnmarshaller<ProtocolMessage> unmarshaller = this.protocolContext.createUnmarshaller();
            Object wrappedInStream = countingIn = new ByteCountingInputStream(socket.getInputStream());
            if (logger.isDebugEnabled()) {
                int maxMsgBuffer = 0x100000;
                copyingInputStream = new CopyingInputStream((InputStream)wrappedInStream, 0x100000);
                wrappedInStream = copyingInputStream;
            }
            try {
                request = unmarshaller.unmarshal((InputStream)wrappedInStream);
            }
            finally {
                if (logger.isDebugEnabled() && wrappedInStream instanceof CopyingInputStream) {
                    copyingInputStream = (CopyingInputStream)wrappedInStream;
                    byte[] receivedMessage = copyingInputStream.getBytesRead();
                    logger.debug("Received message: " + new String(receivedMessage));
                }
            }
            Set<String> nodeIdentities = this.getCertificateIdentities(socket);
            ProtocolHandler desiredHandler = null;
            Collection<ProtocolHandler> handlers = this.getHandlers();
            for (ProtocolHandler handler : handlers) {
                if (!handler.canHandle(request)) continue;
                desiredHandler = handler;
                break;
            }
            if (desiredHandler == null) {
                logger.error("Received request of type {} but none of the following Protocol Handlers were able to process the request: {}", (Object)request.getType(), handlers);
                throw new ProtocolException("No handler assigned to handle message type: " + (Object)((Object)request.getType()));
            }
            ProtocolMessage response = desiredHandler.handle(request, nodeIdentities);
            if (response != null) {
                try {
                    logger.debug("Sending response for request {}", (Object)requestId);
                    ProtocolMessageMarshaller<ProtocolMessage> marshaller = this.protocolContext.createMarshaller();
                    marshaller.marshal(response, socket.getOutputStream());
                }
                catch (IOException ioe) {
                    throw new ProtocolException("Failed marshalling protocol message in response to message type: " + (Object)((Object)request.getType()) + " due to " + ioe, ioe);
                }
            }
            stopWatch.stop();
            NodeIdentifier nodeId = this.getNodeIdentifier(request);
            String from = nodeId == null ? hostname : nodeId.toString();
            logger.info("Finished processing request {} (type={}, length={} bytes) from {} in {}", new Object[]{requestId, request.getType(), countingIn.getBytesRead(), from, stopWatch.getDuration()});
        }
        catch (IOException | ProtocolException e) {
            String msg = "Failed processing protocol message from " + hostname + " due to ";
            if (SocketUtils.isTlsError((Throwable)e)) {
                boolean printedAsWarning = this.handleTlsError(msg, e);
                if (printedAsWarning) {
                    this.tlsErrorLastSeen = System.currentTimeMillis();
                }
            }
            logger.warn(msg + e, (Throwable)e);
            this.publishBulletinWarning(msg + e);
        }
    }

    private boolean handleTlsError(String msg, Throwable e) {
        String populatedMessage = msg + e.getLocalizedMessage();
        if (this.tlsErrorRecentlySeen()) {
            logger.debug(populatedMessage);
            return false;
        }
        logger.warn(populatedMessage);
        this.publishBulletinWarning(populatedMessage);
        return true;
    }

    private void publishBulletinWarning(String message) {
        if (this.bulletinRepository != null) {
            Bulletin bulletin = BulletinFactory.createBulletin((String)"Clustering", (String)"WARNING", (String)message);
            this.bulletinRepository.addBulletin(bulletin);
        }
    }

    private boolean tlsErrorRecentlySeen() {
        long now = System.currentTimeMillis();
        return now - this.tlsErrorLastSeen < 10000L;
    }

    private NodeIdentifier getNodeIdentifier(ProtocolMessage message) {
        if (message == null) {
            return null;
        }
        switch (message.getType()) {
            case CONNECTION_REQUEST: {
                return ((ConnectionRequestMessage)message).getConnectionRequest().getProposedNodeIdentifier();
            }
            case HEARTBEAT: {
                return ((HeartbeatMessage)message).getHeartbeat().getNodeIdentifier();
            }
            case OFFLOAD_REQUEST: {
                return ((OffloadMessage)message).getNodeId();
            }
            case DISCONNECTION_REQUEST: {
                return ((DisconnectMessage)message).getNodeId();
            }
            case FLOW_REQUEST: {
                return ((FlowRequestMessage)message).getNodeId();
            }
            case RECONNECTION_REQUEST: {
                return ((ReconnectionRequestMessage)message).getNodeId();
            }
        }
        return null;
    }

    private Set<String> getCertificateIdentities(Socket socket) throws IOException {
        if (socket instanceof SSLSocket) {
            SSLSession sslSession = ((SSLSocket)socket).getSession();
            Certificate[] peerCertificates = sslSession.getPeerCertificates();
            return this.peerIdentityProvider.getIdentities(peerCertificates);
        }
        return Collections.emptySet();
    }
}

