/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;

public class CountRecordCursorFactory
extends AbstractRecordCursorFactory {
    public static final GenericRecordMetadata DEFAULT_COUNT_METADATA = new GenericRecordMetadata();
    private final RecordCursorFactory base;
    private final CountRecordCursor cursor = new CountRecordCursor();

    public CountRecordCursorFactory(RecordMetadata metadata, RecordCursorFactory base) {
        super(metadata);
        this.base = base;
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        try (RecordCursor baseCursor = this.base.getCursor(executionContext);){
            long size = baseCursor.size();
            if (size < 0L) {
                long count = 0L;
                while (baseCursor.hasNext()) {
                    ++count;
                }
                this.cursor.of(count);
            } else {
                this.cursor.of(size);
            }
            CountRecordCursor countRecordCursor = this.cursor;
            return countRecordCursor;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Count");
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    protected void _close() {
        this.base.close();
    }

    static {
        DEFAULT_COUNT_METADATA.add(new TableColumnMetadata("count", 6));
    }

    private static class CountRecordCursor
    implements NoRandomAccessRecordCursor {
        private final CountRecord countRecord = new CountRecord();
        private long count;
        private boolean hasNext = true;

        private CountRecordCursor() {
        }

        @Override
        public void close() {
        }

        @Override
        public Record getRecord() {
            return this.countRecord;
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext) {
                this.hasNext = false;
                return true;
            }
            return false;
        }

        @Override
        public long size() {
            return 1L;
        }

        @Override
        public void toTop() {
            this.hasNext = true;
        }

        private void of(long count) {
            this.count = count;
            this.toTop();
        }

        private class CountRecord
        implements Record {
            private CountRecord() {
            }

            @Override
            public long getLong(int col) {
                return CountRecordCursor.this.count;
            }
        }
    }
}

